/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "DirectiveWithCondition.hh"

#include <cassert>	// for assert()

using std::string;


DirectiveWithCondition::DirectiveWithCondition(const std::string &line,
		size_t lineNumber,
		LineType lineType,
		const char *cond)
	: LineOfSourceCode(line, lineNumber, lineType) {
	
	// Shouldn't happens because we always got real lines
	assert(cond != NULL);
	
	switch (type) {
		case IFDEF:
			condition_name = "ifdef";
			break;
		
		case IFNDEF:
			condition_name = "ifndef";
			break;
		
		case IF:
			condition_name = "if";
			break;
		
		default:
#ifndef __INTEL_COMPILER
			assert(0 && "DirectiveWithCondition has unknown type!");
#endif
			break;
	}
	
	string condition_line(cond);
	
	// Shouldn't happens because we already test it in
	// SourceFile::LineOfSourceCodeFactory()
	assert(!condition_line.empty());
	
	// plus one because line starts from zero, not from first
	condition = condition_line.substr(0, condition_line.find_last_not_of(" \t") + 1);
}

string
DirectiveWithCondition::toStringWithInvertedCondition() const {
	
	string invertedLine;
	
	string invertedCondition;
	string searchCondition;
	
	string::size_type pos;
	
	if (type == IFDEF) {
		invertedCondition = "ifndef";
		searchCondition = "ifdef";
	
	} else if (type == IFNDEF) {
		invertedCondition = "ifdef";
		searchCondition = "ifndef";
	
	} else {
#ifndef __INTEL_COMPILER
		// Shouldn't happens because this function should be called
		// only for #if[n]def's
		assert(0 && "Called DirectiveWithCondition::toStringWithInvertedCondition() for not #if[n]def!");
#endif
	}
	
	pos = sourceLine.find(searchCondition);
	
	// Shouldn't happens because this function should be called only
	// for #if[n]def's
	assert(pos != string::npos);
	
	invertedLine =
		sourceLine.substr(0, pos) +
		invertedCondition +
		sourceLine.substr(pos + searchCondition.size());
	
	return invertedLine;
}

