/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class DirectiveWithCondition
 * Line of source code with \#if, \#ifdef or \#ifndef directive.
 * Class uses for presenting lines of source code which contains
 * condition directives (\#if, \#ifdef and \#ifndef).
 **/

#ifndef DIRECTIVEWITHCONDITION_HH
#define DIRECTIVEWITHCONDITION_HH

#include "LineOfSourceCode.hh"

class DirectiveWithCondition : public LineOfSourceCode {
public:
	DirectiveWithCondition(const std::string &line,
			size_t lineNumber,
			LineType lineType,
			const char *cond);
	
	std::string toStringWithInvertedCondition() const;
	const std::string &getCondition() const {return condition;}
	const std::string &getConditionName() const {return condition_name;}
	
	bool operator<(const DirectiveWithCondition &lhs) const {
		return getCondition() < lhs.getCondition();
	}
	
	bool operator==(const DirectiveWithCondition &lhs) const {
		return (getType() == lhs.getType() && getCondition() == lhs.getCondition());
	}
	
private:
	std::string condition;
	std::string condition_name;
};

#endif // !DIRECTIVEWITHCONDITION_HH

