/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Header.hh"
#include "syntax_error.hh"		// for syntax_error exception

#include <cassert>	// for assert()

#ifdef ENABLE_BOOST
#include <boost/algorithm/string/trim.hpp>
using boost::trim_right_copy;
#endif

using std::string;


Header::Header(const std::string &line, size_t lineNumber,
		LineType lineType, char begin, char end, const char *start)
	: LineOfSourceCode(line, lineNumber, lineType) {
	
	if (lineType == UNKHDR) {
		if (start != NULL) {
			string name = string(start);
			
			// get rid of trailing blank symbols
#ifndef ENABLE_BOOST
			string::size_type pos = name.find_last_not_of(" \t");
			assert(pos != string::npos);
			headerName = name.substr(0, pos+1);
#else
			headerName = trim_right_copy(name);
#endif
		}
		
		return;
	}
		
	string::size_type from;
	string::size_type to;
	
	// Shouldn't happens because we already test it in
	// SourceFile::LineOfSourceCodeFactory()
	assert(! line.empty());
	
	from = line.find_first_of(begin);
	// Shouldn't happens because we already test it in
	// SourceFile::_isHeader()
	assert(from != string::npos);
	
	from++;	// start from next character
	
	to = line.find_first_of(end, from);
	// Shouldn't happens because we already test it in
	// SourceFile::_isHeader()
	assert(to != string::npos);
	
	// in case when #include <> or #include ""
	// see test #050
	if (from == to) {
		throw syntax_error("empty filename in #include", lineNumber);
	}
	
	headerName = line.substr(from, to-from);
}

