/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class Patch
 * Emulates patch program.
 * Class used for creation patches like diff(1) produces and which may
 * be applied by patch(1) command.
 **/

#ifndef PATCH_HH
#define PATCH_HH

#include <map>
#include <set>
#include <string>
#include <vector>

class Hunk;
class DirectSourceFile;

class Patch {

public:
	static void produce(const DirectSourceFile &sf,
		const std::set<size_t> &deleted_lines_list,
		const std::set<size_t> &added_lines_list,
		const std::map<size_t, size_t> &replaced_lines,
		bool print_banner = true);

private:
	static std::string convertTimeToDate(const time_t *time);
	static std::string getFileModificationDate(const std::string &fileName);
	static std::string getCurrentDate();
	
	static std::string getHeader(const std::string &fileName);
	static void printBanner();
	
	static void addLineToHunkAsRemoved(std::vector<Hunk> *hunks, size_t lineno);
	static void addLineToHunkAsAdded(std::vector<Hunk> *hunks, size_t lineno);
};

#endif // !PATCH_HH

