/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class TextFile
 * Abstraction of text file.
 * Class contains base methods for working with text file:
 * getting its name and operate with lines.
 **/

#ifndef TEXTFILE_HH
#define TEXTFILE_HH

#include <string>	// for string class

class TextFile {
public:
	explicit TextFile(const std::string &filename) : fileName(filename) {}
	virtual ~TextFile() {}
	
	const std::string &getFileName() const {return fileName;}
	
	virtual size_t getNumberOfLastLine() const = 0;
	static size_t getNumberOfFirstLine() {return 1;}
	
	static size_t getNumberOfPreviousLine(size_t lineno) {return lineno-1;}
	static size_t getNumberOfNextLine(size_t lineno) {return lineno+1;}
	
private:
	const std::string fileName;
};

#endif // !TEXTFILE_HH

