#!/bin/sh

RET=0

if [ $# -ne 1 ]; then
	printf 'Usage: %s file\n' "$0"
	exit 1
fi

FILE="$1"; shift

if grep -q '){' "$FILE"; then
	echo 'You forgot add one space between brackets:'
	grep -Hn --color '){' "$FILE"
	echo
	RET=1
fi

if grep -q '{[[:space:]]*}[[:space:]]*;' "$FILE"; then
	echo 'Found useless semicolon after empty body of function:'
	grep -Hn --color '{[[:space:]]*}[[:space:]]*;' "$FILE"
	echo
	RET=1
fi

SUFFIX="`printf '%s\n' "$FILE" | sed 's|.\+\.\(.\+\)$|\1|'`"
if [ "$SUFFIX" = 'cc' ]; then
	
	#if grep -v 'using[[:space:]]\+std::' "$FILE" | grep -q 'std::'; then
	#	echo -n "Don't specify namespace in file with implementation"
	#	echo ' (use using directive instead):'
	#	grep -v 'using[[:space:]]\+std::' "$FILE" |
	#	grep -n 'std::' |
	#	awk -v file="$FILE" '{printf("%s:%s\n",file,$0)}' |
	#	grep --color 'std::'
	#	echo
	#	RET=1
	#fi
	
	FOUND=
	
	for namespace in std boost; do
		grep -o "using[[:space:]]\+$namespace::[^;]\+" "$FILE" |
		while IFS=':' read USING EMPTY NAME; do
			SHORT_NAME=`echo "$NAME" | rev | cut -d':' -f1 | rev`
			COUNT=`grep -c "$SHORT_NAME" "$FILE"`
			if [ $COUNT -eq 1 ]; then
				if [ -z "$FOUND" ]; then
					echo "Found unused using directives:"
				fi
				grep -Hn --color "using[[:space:]]\+$namespace::$NAME;" "$FILE"
				FOUND=yes
				RET=1
			fi
		done
	done
fi

exit $RET

