/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class Algorithm
 * Set of methods and algorithms for operate with lines of source code.
 * Class used for working with lines of source code and find which of
 * \#include directives are duplicated.
 **/

#ifndef ALGORITHM_HH
#define ALGORITHM_HH

#include <utility>
#include <vector>
#include "syntax_error.hh"

#include "Header.hh"

class DirectiveWithCondition;
class SourceFile;

class Algorithm {
public:
	typedef std::pair<CHdrPtr, CHdrPtr> DuplPair;
	
	/*
	 * methods for working with Header class
	 */
	static std::vector<CHdrPtr>
		getHeaders(const SourceFile *sf);
	
	static std::vector<DuplPair>
		getDuplicatedHeadersPairs(std::vector<CHdrPtr> headers_list);
	
	static std::vector<Algorithm::DuplPair>
		excludeHeadersWithDifferentTypes(
				std::vector<Algorithm::DuplPair> duplicated_pairs);
	
	static std::vector<size_t>
		getEarlyIncludedHeaders(CHdrPtr hdr,
			std::vector<Algorithm::DuplPair> duplicated_pairs);
	
	
	// typedefs for working with DirectiveWithCondition class
	typedef const DirectiveWithCondition *CDrtvPtr;
	typedef std::pair<CDrtvPtr, size_t> DrtvPair;
	
	/*
	 * methods for working with DirectiveWithCondition class
	 */
	static std::vector<DrtvPair>
		getDirectivesPairs(const SourceFile *sf, std::vector<syntax_error> &errors);
	
	static std::vector<Algorithm::CDrtvPtr>
		getConditionsAffectsToLine(std::vector<DrtvPair> condition_pairs, size_t lineno);
};


#endif // !ALGORITHM_HH

