/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class Hunk
 * Represent hunk of patch.
 * Class represent hunk which is usually part of patch.
 **/

#ifndef HUNK_HH
#define HUNK_HH

#include <map>
#include <vector>

class DirectSourceFile;

class Hunk {
public:
	Hunk(size_t lineno, bool add_for_deletion = true);
	
	void pushLineForDeletion(size_t lineno);
	void pushLineForAddition(size_t lineno);
	void printHunk(const DirectSourceFile &sf,
			const std::map<size_t, size_t> &replaced_lines,
			int lines_offset) const;
	
	size_t getNumberOfFirstDeletedLine() const;
	size_t getNumberOfLastDeletedLine() const;
	
	size_t getNumberOfFirstAddedLine() const;
	size_t getNumberOfLastAddedLine() const;
	
	size_t getNumberOfFirstLine() const;
	size_t getNumberOfLastLine(size_t lines_in_file) const;
	
	size_t getNumberOfFirstModifiedLine() const;
	size_t getNumberOfLastModifiedLine() const;
	
	bool isLineBelongsToHunk(size_t lineno) const;
	
#ifndef ENABLE_BOOST
	static bool isLineBelongsToHunk(Hunk hunk, size_t lineno);
#endif
	
	int getOffsetCreatedByHunk() const;
	
private:
	static const size_t context = 3;
	
	std::vector<size_t> deleted_lines;
	std::vector<size_t> added_lines;
};

#endif // !HUNK_HH

