/*
 * Copyright (C) 2007-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class IndirectSourceFile
 * File with source code which program use implicitly.
 * Class usually presents header files which \#include'd in file
 * specified by user.
 **/

#ifndef INDIRECTSOURCEFILE_HH
#define INDIRECTSOURCEFILE_HH

#include "SourceFile.hh"

class IndirectSourceFile : public SourceFile {
public:
	IndirectSourceFile(const std::string &filename, int recursion_level);
	virtual void printHeaderTree(bool nflag, size_t level = 1) const;
	bool isFileExists() const {return fileWasOpened;}

private:
	bool fileWasOpened;
};

#endif // !INDIRECTSOURCEFILE_HH

