/*
 * Copyright (C) 2007-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class SourceFile
 * Abstraction of file with source code.
 **/

#ifndef SOURCEFILE_HH
#define SOURCEFILE_HH

#include <vector>	// for vector class

#include "LineOfSourceCode.hh"
#include "TextFile.hh"

class Header;


class SourceFile : public TextFile {
public:
	explicit SourceFile(const std::string &filename);
	virtual ~SourceFile();
	virtual void printHeaderTree(bool nflag, size_t level = 1) const = 0;
	
	virtual size_t getNumberOfLastLine() const {return sourceFile.size();}
	const LineOfSourceCode &operator[](size_t lineno) const;
	
	const LineOfSourceCode *getLineOfSourceCodeClass(size_t lineno) const {
		// because numbers of lines in file starts from 1, but
		// elements in vector starts from 0
		return sourceFile.at(lineno-1);
	};
	
private:
#ifdef ENABLE_UNIT_TEST
	// See tests/unit-test.cc file as simple unit test example
	friend int main();
#endif
	static LineOfSourceCode *
		LineOfSourceCodeFactory(const std::string &line, size_t lineno, bool inside_multiline_comment = false);
	
	static const char *isDirective(const char *str);
	static const char *detectDirective(const char *str, const char *directiveName);
	static bool isComment(const char *str);
	
	static bool isStringLastOrAfterAnotherString(const std::string &line,
				const char *str, const char *other_str);
	static bool isMultilineCommentStart(const std::string &line);
	static bool isMultilineCommentEnd(const std::string &line);
	static bool isStringInsideDoubleQuotes(const std::string &line);
	
	static LineType determineHeaderType(const char *str);

protected:
	void parseSourceFile();
	
	// source file line by line
	std::vector<LineOfSourceCode *> sourceFile;
	
	// Path to file with slash at end.
	// Empty string if file located inside current directory.
	std::string filePath;
	
	static const int RECURSIVE_MODE_DISABLED = -1;
	static const int RECURSIVE_MODE_DEFAULT_DEEP = 50;
	
};

#endif // !SOURCEFILE_HH

