/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class SystemHeader
 * Line of source code with \#include <> directive.
 * Class used for presenting lines of source code which include
 * system headers (uses \#include <> directive).
 **/


#ifndef SYSTEMHEADER_HH
#define SYSTEMHEADER_HH

#include "Header.hh"

class SystemHeader : public Header {
public:
	SystemHeader(const std::string &line, size_t lineNumber)
		: Header(line, lineNumber, SYSHDR, '<', '>') {}
};

#endif // !SYSTEMHEADER_HH

