/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class UserHeader
 * Line of source code with \#include "" directive.
 * Class used for presenting lines of source code which include
 * user headers (uses \#include "" directive).
 **/

#ifndef USERHEADER_HH
#define USERHEADER_HH

#include "Header.hh"
#include "DirectSourceFile.hh"
#include "IndirectSourceFile.hh"

class UserHeader : public Header {
public:
	UserHeader(const std::string &line, size_t lineNumber)
		: Header(line, lineNumber, USRHDR, '"', '"'), usf(NULL) {}
	~UserHeader() {delete usf;}
	
	void setSourceFile(const IndirectSourceFile *isf) {usf = isf;}
	const IndirectSourceFile *getSourceFile() const {return usf;}
	
private:
	const IndirectSourceFile *usf;	// used for get access to content of user header
};

#endif // !USERHEADER_HH

