/*
 * Copyright (C) 2008-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class syntax_error
 * Exception with information about syntax error.
 * Class used only as exception object.
 **/

#ifndef SYNTAX_ERROR_HH
#define SYNTAX_ERROR_HH

#include <stdexcept>	// for runtime_error exception

class syntax_error : public std::runtime_error {
public:
	syntax_error(const std::string &msg, size_t line) :
		std::runtime_error(msg), lineno(line) { }
	virtual ~syntax_error() throw() { }
	
	size_t where() const {return lineno;}

private:
	size_t lineno;
};

#endif // !SYNTAX_ERROR_HH
