/*
 * Copyright (C) 2007-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <iostream>	// for cerr, cout, endl
#include <cstdlib>	// for EXIT_SUCCESS constant
#include <vector>	// for vector

#include "LineOfSourceCode.hh"	// for LineOfSourceCode class
#include "SourceFile.hh"
#include "syntax_error.hh"		// for syntax_error class

using std::string;
using std::vector;
using std::cerr;
using std::cout;
using std::endl;

int main() {

	vector<string> code;
	code.push_back("#include <stdio.h>");
	code.push_back("#include <sys/types.h>");
	code.push_back("#include <net/if_dl.h>");
	code.push_back("#include <libpq-fe.h>");
	code.push_back("#include <Magick++.h>");
	code.push_back("#include \"common.h\"");
	code.push_back("#if CONDITION");
	code.push_back("#ifdef HAVE_STDIO_H");
	code.push_back("#ifndef HAVE_STRINGS_H");
	code.push_back("#else");
	code.push_back("#elif VAR == 1");
	code.push_back("#endif");
	code.push_back("#define TRUE 1");
	code.push_back("");
	code.push_back("   ");
	code.push_back("\t ");
	code.push_back("exit(EXIT_SUCCESS);");
	code.push_back("//");
	code.push_back("/**/");
	code.push_back("	/* test */	/* test */");
	code.push_back("break;	// comment");
	code.push_back("/*");
	code.push_back(" // test /**/");
	code.push_back("	/* comment */");
	code.push_back("/* FOO */  ");
	code.push_back("/* comment */ code here");
	code.push_back("i++;	/* comment */");
	code.push_back("#undef VAR");
	code.push_back("#include  ");
	code.push_back("#include FOO");
	code.push_back("0");

	size_t i = 1;

	for (vector<string>::const_iterator vec = code.begin();
			vec != code.end();
			++vec) {
		
		LineOfSourceCode *losc;
		try {
			losc = SourceFile::LineOfSourceCodeFactory(*vec, i++);
		} catch (const syntax_error &e) {
			cerr << *vec << " has syntax error: " << e.what() << endl;
			continue;
		}

		cout << *vec << " is ";

		switch (losc->getType()) {
			
			case BLANK:
				cout << "blank line";
				break;
			
			case COMMENT:
				cout << "comment";
				break;
			
			case USRHDR:
				cout << "user #include";
				break;
			
			case SYSHDR:
				cout << "system #include";
				break;
			
			case UNKHDR:
				cout << "#include with unknown type";
				break;
			
			case IF:
				cout << "#if";
				break;
			
			case IFDEF:
				cout << "#ifdef";
				break;
			
			case IFNDEF:
				cout << "#ifndef";
				break;
			
			case ELIF:
				cout << "#elif";
				break;
			
			case ELSE:
				cout << "#else";
				break;
			
			case ENDIF:
				cout << "#endif";
				break;
			
			case DEFINE:
				cout << "#define";
				break;
			
			case UNDEF:
				cout << "#undef";
				break;
			
			default:
				cout << "code or unknown directive";
				break;
		}

		cout << endl;
	}

	return EXIT_SUCCESS;
}
