;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Default initial modes, editing properties, etc.
;; (set up only when launched in non-batch mode (interactively))
(Interactive-launch

; Don't add lines on the end of lines unless we want.
;;  (setq next-line-add-newlines nil)


;; Show parenthesis mode
 (show-paren-mode t)
;; Show column number:
 (column-number-mode t)


 (defun flyspell-mode-noerr() "Defined mainly for use in hook lists.

Try to call flyspell-mode (turn it on) and catch any fatal errors 
that can happen. On failure, write a message and turn it off. 
The errors I'm concerned with when defining this function are: 
wrong ispell-dictionary value, some problems launching ispell, etc.

You could use, for example, 

\(add-hook 'text-mode-hook 'flyspell-mode-noerr\)
or \(remove-hook 'text-mode-hook 'flyspell-mode-noerr\)

to add or remove the autostart of Flyspell in text-modes."
   (condition-case errdata 
       (flyspell-mode t)
     ('error 
      (message "Failed turning Flyspell mode on, ignoring: %s" 
	       (cadr errdata))
      (condition-case errdata2
	  (flyspell-mode nil)
	('error 
	 (message "Failed turning Flyspell mode off, ignoring: %s" 
		  (cadr errdata2)))))))

; Use remove-hook to turn-off
 (add-hook 'text-mode-hook 'turn-on-auto-fill)
 (add-hook 'text-mode-hook 'flyspell-mode-noerr)
 (setq ispell-dictionary (getenv "DICTIONARY"))

;; By default start in text mode.
 (setq initial-major-mode 'text-mode)

;; Show short documentation for elements of Emacs Lisp:
 (add-hook 'emacs-lisp-mode-hook 'eldoc-mode)

; Don't ask to revert for TAGS
 (setq revert-without-query (cons "TAGS" revert-without-query))

;; Save positions in files between sessions
 (require 'saveplace)
 (setq-default save-place t))

;; End of default initial modes section -- end of Interactive-launch block
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq sendmail-program "/usr/lib/sendmail")
; Use the following for i18n
;(standard-display-european t)
;(GNUEmacs (set-language-environment "latin-1"))

