#
# Copyright (c) 2004 Jeff Pitman <symbiont@berlios.de>
#
# alternatives-display - utility from alternatives subsystem
# displays alternative candidates in debian/redhat format
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
# USA.
#

BEGIN {
    state="auto"
    while(getline<manual_file) {
        if($0 ~ namepat) {
            state="manual"
        }
    }
    close(manual_file)
    base = gensub(/\/.*\//, "", "g", name)
    print base " - status is " state
    print " link currently points to " current
}

# Non-priority ending lines are slaves
!/.*(\t[[:digit:]]+)$/ {
    slaves[NR] = $0
}

$0 ~ namepat {
    masters[NR] = $0
}

END {
    pri = 0
    for(mi in masters) {
        split(masters[mi], mf, "\t")
        print mf[2] " - priority " mf[3]
        if(mf[3] > pri) {
            pri = mf[3]
            best = mf[2]
        }
        for(si in slaves) {
            split(slaves[si], sf, "\t")
            if(mf[2] == sf[3]) {
                base = gensub(/\/.*\//, "", "g", sf[1])
                print " slave " base ": " sf[2]
            }
        }
    }
    print "Current ``best\" version is " best "."
}
