" Filename:    spec.vim
" Purpose:     Vim syntax file
" Language:    SPEC: Build/install scripts for Linux RPM packages
" Maintainer:  Donovan Rebbechi elflord@pegasus.rutgers.edu
" URL:         http://pegasus.rutgers.edu/~elflord/vim/syntax/spec.vim
" Last change: Tue Abr 16 16:58:34 EST 2001 <verde@conectiva.com.br>

" Changelog:   Wed Sep 22: several improvements and fixes. Added preamble tags
"              and %ifFOO macros. Removed all hardcoded colours.
"              Wed Oct 20: Added %lang
"              Sat Nov 27: fixed a typo
"
" CHANGELO(N)G - 03 october 2000 <verde@conectiva.com.br>
" ------------
"syntax is now "contained", defined areas are only highlighted in valid places,
"  i.e. %doc and %dir are only valid in %files section
"macros/vars recognized in all formats: %macro, %{macro}, $macro, ${macro}
"specWeekday & specMonth: are now \<atoms\> (keywords)
"created: specLicense, specPercent, shQuote*
"changed names of some regions
"specTarCommand: I and p options added, ER improved
"specPreAmble: new fields added, deprecated fields with Error syntax
"  (see specPreAmbleDeprecated)
"various regexps improved like specEmail,specURL,specCommandOpts
"specURLMacro: macros are highlighted inside URLs
"spec*Opts: section valid options are recognized (%description, %package and %files)
"specMacroName*: included *ALL* %[A-z] and %_[A-z] macros from /usr/lib/rpm/macros
"sections and section macros *HAVE* to be at the begining of the line
"  i.e. %prep, %install, %configure
"specComment != shComment (and each one valid in its own section)
"shQuote*: treating '' and "" as strings
"new set of colors, identifying diferent type of macros
"more comments on the syntax file, to help maintance
"
"  <verde@conectiva.com.br>
"20001026 specIf also permitted in %files
"20010220 blank spaces permitted at specSectionMacroArea beginning 
"         %trigger == %post, BuildPreReq tag is now obsoleted
"20010322 PACKAGE_(VERSION|RELEASE) tags accepted
"20010410 -:- a spec's shell area total cleanup -:-
"         deleted specIfError,shFunction,sh...Error references (not defined)
"         sh...Keys: areas created (now all structures seems ok)
"         specIfKeys: created to avoid %else being start of block
"         specTarCommand: requires at least 2 options like: tar tf file
"         shQuote1: \' NOT permitted
"         shSubshell: created area for `` and $()
"         shOperators: added things like 2>&1, <&- and -lt
"         specCommand: 'basename' in and 'moc' out
"         specCommand: most of commands requires arguments (\s after)
"         ...All: created various clusters to help the maintaince
"         specNumber: improved and specNoNumberHilite deleted
"         wiped all the contains=ALLBUT from the syntax file. they REALLY suck.
"20010521 specScriptArea: added triggerpostun
"         shIf, shDo, shCase: s/\<if\>/\<if\s/
"         specCommand: added chown
"20010606 specPreAmble: BuildConflicts tag confirmed ok
"         shSpecial: created to handle \" not inside shQuote2
"         shHereDoc: created ( <<-EOF )
"         specScriptArea: added trigger(in|un), removed trigger
"20010628 specIf: %if added
"         specScriptArea: %verifyscript added
"20010807 specURL, specURLMacro: added + as a valid char
"         shHereDoc: added \s* at <<-EOF tag
"20010815 specSectionMacroArea: added specSpecialChar
"20010824 specMacroCommand{,Delim}: added for %(shell command) - tks rsd
"         specMacroConditional{,Delim}: added for %{!?macro: conditional}
"20020625 shIf,shDo,shCase: added ^ in triggerpostun <renato@conectiva.com.br>

"TODO %files in %if, bugged
"TODO register %files macros directives?
"TODO why shSpecial and shHereDoc colors doesn't work?

syn clear
syn sync minlines=1000

syn match specSpecialChar contained '[][()!$\\|>^;:{}&]'
syn match specColon       contained ':'
syn match specPercent     contained '%'

syn match specVariables   contained '\\\@<!\$\h\w*' contains=specSpecialVariablesNames,specSpecialChar
syn match specVariables   contained '\\\@<!\${\w*}' contains=specSpecialVariablesNames,specSpecialChar

syn match specMacroIdentifier contained '%\@<!%\h\w*' contains=specMacroNameLocal,specMacroNameOther,specPercent
syn match specMacroIdentifier contained '%\@<!%{\w*}' contains=specMacroNameLocal,specMacroNameOther,specPercent,specSpecialChar

syn match specMacroCommand contained '%\@<!%(.\{-}[^\\])' contains=specMacroCommandDelim,specMacroIdentifier,shSpecial,shQuote1,shQuote2,shOperator,specCommand,specSpecialChar,specCommandOpts
syn match specMacroCommandDelim contained '%\@<!%('
syn match specMacroCommandDelim contained '[^\\])'ms=s+1

syn match specMacroConditional '%\@<!%{!\=?\w\+:.*}' contains=specMacroConditionalDelim,specMacroIdentifier
syn match specMacroConditionalDelim contained '%\@<!%{!\=?\w\+:\|}'

syn match specSpecialVariables contained '\\\@<!\$[0-9]\|\\\@<!\${[0-9]}'
syn match specCommandOpts      contained '\s\(-\w\+\|--\w[a-zA-Z_-]\+\)'ms=s+1
syn match specComment '^\s*#.*$'


"all the clusters defined
syn cluster specCommands contains=specCommand,specTarCommand,specConfigure,specCommandSpecial,specCommandOpts
syn cluster specListedFiles contains=specListedFilesBin,specListedFilesLib,specListedFilesDoc,specListedFilesEtc,specListedFilesShare,specListedFilesPrefix,specVariables,specSpecialChar

syn cluster specSectionAll contains=specPreAmbleDeprecated,specPreAmble,specDescriptionArea,specPackageArea,specScriptArea,specChangelogArea,specFilesArea
syn cluster shAll contains=shComment,shSpecial,shQuote1,shQuote2,shHereDoc,shOperator,shSubshell,shIf,shDo,shCase
syn cluster specVarsAll contains=specVariables,specSpecialVariables,specMacroIdentifier
syn cluster specScriptAll contains=specSpecialChar,specNumber,specSectionMacroArea,specSectionMacroBracketArea,specMacroCommandLocal,specMacroCommandLocalBracketed,@shAll,@specVarsAll,@specCommands

syn case match


"matches with no highlight
syn match specManpageFile '[a-zA-Z]\.[1-8n]'

"Day, Month and most used license acronyms
syn keyword specLicense contained GPL LGPL FDL BSD MIT MITX MPL NPL OCL QPL W3C SPL ZPL Apache Artistic OpenLDAP Sendmail OpenPub XConsortium Zlib
syn keyword specWeekday contained Mon Tue Wed Thu Fri Sat Sun
syn keyword specMonth   contained Jan Feb Mar Apr Jun Jul Aug Sep Oct Nov Dec
syn keyword specMonth   contained January February March April May June July August September October November December

"#, @, www
syn match specNumber '\(^-\=\|[ \t]-\=\|-\)\<[0-9.-]*[0-9]\>'
syn match specEmail    contained '<\=\<[A-Za-z0-9_.-]\+@\([A-Za-z0-9_-]\+\.\)\+[A-Za-z]\+\>>\='
syn match specURL      contained '\<\(\(https\{0,1}\|ftp\)://\|\(www[23]\{0,1}\.\|ftp\.\)\)[A-Za-z0-9._/~:,#+-]\+\>'
syn match specURLMacro contained '\<\(\(https\{0,1}\|ftp\)://\|\(www[23]\{0,1}\.\|ftp\.\)\)[A-Za-z0-9._/~:,#%{}+-]\+\>' contains=specMacroIdentifier

"Special system directories
syn match specListedFilesPrefix contained '/\(usr\|local\|opt\|X11R6\|X11\)/'me=e-1
syn match specListedFilesBin    contained '/s\=bin/'me=e-1
syn match specListedFilesLib    contained '/\(lib\|include\)/'me=e-1
syn match specListedFilesDoc    contained '/\(man\d*\|doc\|info\)\>'
syn match specListedFilesEtc    contained '/etc/'me=e-1
syn match specListedFilesShare  contained '/share/'me=e-1

"specCommands
syn match   specConfigure  contained '\(\(\.\./\)*\.\)\{0,1}\./configure'
syn match   specTarCommand contained '\<tar\s\+-\=[cxvpzIf]\{2,5}\s*'
syn keyword specCommandSpecial contained root
syn keyword specCommand    contained cd echo make xmkmf autoconf automake libtool
syn match   specCommand    contained '\<\(basename\|cat\|chmod\|chown\|cp\|eval\|export\|find\|grep\|gzip\|iconv\|install\|ln\|ls\|mkdir\|moc\|mv\|pwd\|rm\|rmdir\|sed\|sleep\|strip\|subst\|tail\|touch\|unset\|xargs\)\s'me=e-1

"frequently used rpm env vars
syn keyword specSpecialVariablesNames contained AUTOCONF_VERSION AUTOMAKE_VERSION CC CCACHE_CC CCACHE_CXX CCACHE_DIR CFLAGS CXX CXXFLAGS FFLAGS GCC_VERSION INSTALL LD_LIBRARY_PATH LIBTOOL_VERSION MAKEFLAGS NPROCS PAM_NAME_SUFFIX PAM_SO_SUFFIX PATH RPM_ARCH RPM_BUILD_DIR RPM_BUILD_NCPUS RPM_BUILD_ROOT RPM_CLEANUP_METHOD RPM_CLEANUP_SKIPLIST RPM_CLEANUP_TOPDIR RPM_COMPRESS_METHOD RPM_COMPRESS_SKIPLIST RPM_COMPRESS_TOPDIR RPM_DOC_DIR RPM_FINDPROV_DEFAULT_METHOD RPM_FINDPROV_LIB_PATH RPM_FINDPROV_METHOD RPM_FINDPROV_SKIPLIST RPM_FINDPROV_TOPDIR RPM_FINDREQ_DEFAULT_METHOD RPM_FINDREQ_METHOD RPM_FINDREQ_SKIPLIST RPM_FINDREQ_TOPDIR RPM_FIXUP_METHOD RPM_FIXUP_SKIPLIST RPM_FIXUP_TOPDIR RPM_KEEP_LIBTOOL_FILES RPM_OPT_FLAGS RPM_OS RPM_PACKAGE_NAME RPM_PACKAGE_RELEASE RPM_PACKAGE_VERSION RPM_PERL_LIB_PATH RPM_PERL_REQ_METHOD RPM_PKG_CONTENTS_INDEX_ALL RPM_PKG_CONTENTS_INDEX_BIN RPM_PYTHON RPM_PYTHON_COMPILE_CLEAN RPM_PYTHON_COMPILE_DEEP RPM_PYTHON_COMPILE_EXCLUDE RPM_PYTHON_COMPILE_INCLUDE RPM_PYTHON_COMPILE_METHOD RPM_PYTHON_COMPILE_SKIP_X RPM_PYTHON_LIB_PATH RPM_PYTHON_REQ_METHOD RPM_PYTHON_REQ_SKIP RPM_SCRIPTS_DEBUG RPM_SOURCE_DIR RPM_STRIP_METHOD RPM_STRIP_SKIPLIST RPM_STRIP_TOPDIR RPM_VERIFY_ELF_METHOD RPM_VERIFY_ELF_SKIPLIST RPM_VERIFY_ELF_TOPDIR

"valid macro names from /usr/lib/rpm/macros
syn keyword specMacroNameOther contained amd buildroot buildsubdir distribution disturl intel ix86 nil optflags optflags_core optflags_debug optflags_default optflags_fastmath optflags_kernel optflags_nocpp optflags_notraceback optflags_optimization optflags_shared optflags_strict optflags_warnings prefix vendor serial name version release epoch
syn match   specMacroNameOther contained '\<\(PATCH\|SOURCE\)\d*\>'

"valid _macro names from /usr/lib/rpm/macros
syn keyword specMacroNameLocal contained _arch _bindir _build _build_alias _build_arch _build_cpu _builddir _build_name_fmt _build_os _buildshell _build_vendor _bzip2bin _cachedir _cleanup_method _cleanup_skiplist _cleanup_topdir _compress_method _compress_skiplist _compress_topdir _configure_gettext _configure_target _datadir _dbapi _dbapi_rebuild _dbi_btconfig _dbi_config _dbi_config_Depends _dbi_config_Dirnames _dbi_config_Installtid _dbi_config_Packages _dbi_config_Provideversion _dbi_config_Removetid _dbi_config_Requireversion _dbi_htconfig _dbi_tags _dbpath _dbpath_rebuild _defattr _defaultdocdir _emacslispdir _exec_prefix _findprov_default_method _findprov_lib_path _findprov_skiplist _findprov_topdir _findreq_default_method _findreq_skiplist _findreq_topdir _fixup_method _fixup_skiplist _fixup_topdir _gamesbindir _gamesdatadir _gamesdir _gnu _gzipbin _host _host_alias _host_cpu _host_os _host_vendor _iconsdir _includedir _infodir _initdir _initrddir _install_script_path _instchangelog _internal_gpg_path _lib _libdir _libexecdir _licensedir _liconsdir _localstatedir _lockdir _logdir _makeinstall_target _man1dir _man2dir _man3dir _man4dir _man5dir _man6dir _man7dir _man8dir _man9dir _mandir _menudir _miconsdir _oldincludedir _optlevel _os _package_version _perl_req_method _pgpbin _prefix _query_selector_match _repackage_dir _repackage_name_fmt _repackage_root _rpmdir _rpmfilename _sbindir _sharedstatedir _signature _smp_mflags _sourcedir _specdir _spooldir _srcrpmdir _strip_method _strip_skiplist _strip_topdir _sysconfdir _target _target_alias _target_cpu _target_os _target_platform _target_vendor _tcldatadir _tcllibdir _tmppath _topdir _topsrcdir _unzipbin _usr _usrsrc _var _vendor _verify_elf_method _verify_elf_skiplist _verify_elf_topdir _x11bindir _x11datadir _x11dir _x11fontsdir _x11includedir _x11libdir _x11mandir packagerName packagerAddress __dbi_btconfig __dbi_btconfig_current __dbi_btconfig_rebuild __dbi_htconfig __dbi_htconfig_current __dbi_htconfig_rebuild __dbi_other __dbi_perms __dbi_rebuild __dbi_transient __gcc_version __gcc_version_base __gcc_version_major __gcc_version_minor __gcc_version_patch __glibc_version __glibc_version_major __glibc_version_minor __nprocs __python_version

"some of them are essentially commands
syn region specMacroCommandLocal matchgroup=specSectionMacro start='%\@<!%\(update_wms\|update_scrollkeeper\|update_menus\|uninstall_info\|strip_static\|strip_shared\|strip_relocatable\|strip_executable\|strip_binaries\|set_verify_elf_topdir\|set_verify_elf_skiplist\|set_verify_elf_method\|set_strip_topdir\|set_strip_skiplist\|set_strip_method\|set_perl_req_method\|set_libtool_version\|set_gcc_version\|set_fixup_topdir\|set_fixup_skiplist\|set_fixup_method\|set_findreq_topdir\|set_findreq_skiplist\|set_findprov_topdir\|set_findprov_skiplist\|set_compress_topdir\|set_compress_skiplist\|set_compress_method\|set_cleanup_topdir\|set_cleanup_skiplist\|set_cleanup_method\|set_automake_version\|set_autoconf_version\|remove_optflags\|preun_service\|postun_ldconfig\|post_service\|post_ldconfig_sys\|post_ldconfig_lib\|post_ldconfig\|make_session\|make_install\|make_compile\|make_build\|make\|install_info\|find_lang\|compress_docs\|cleanup_build\|clean_wms\|clean_scrollkeeper\|clean_menus\|clean_buildroot\|add_verify_elf_skiplist\|add_strip_skiplist\|add_serial\|add_optflags\|add_fixup_skiplist\|add_findreq_skiplist\|add_findprov_skiplist\|add_compress_skiplist\|add_cleanup_skiplist\|_update_wms_bin\|_update_scrollkeeper_bin\|_update_menus_bin\|_remove_install_info\|_make_bin\|_install_langs\|_install_info\|_fixperms\|_fixowner\|_fixgroup\|_defattr\|_configure_script\|__unzip\|__tar\|__subst\|__strip\|__ssh\|__spec_rmbuild_template\|__spec_rmbuild_shell\|__spec_rmbuild_pre\|__spec_rmbuild_post\|__spec_rmbuild_custom_pre\|__spec_rmbuild_custom_post\|__spec_rmbuild_cmd\|__spec_rmbuild_body\|__spec_rmbuild_args\|__spec_prep_template\|__spec_prep_shell\|__spec_prep_pre\|__spec_prep_post\|__spec_prep_custom_pre\|__spec_prep_custom_post\|__spec_prep_cmd\|__spec_prep_body\|__spec_prep_args\|__spec_install_template\|__spec_install_shell\|__spec_install_pre\|__spec_install_pre\|__spec_install_post\|__spec_install_custom_pre\|__spec_install_custom_post\|__spec_install_cmd\|__spec_install_body\|__spec_install_args\|__spec_clean_template\|__spec_clean_shell\|__spec_clean_pre\|__spec_clean_post\|__spec_clean_post\|__spec_clean_custom_pre\|__spec_clean_custom_post\|__spec_clean_cmd\|__spec_clean_body\|__spec_clean_args\|__spec_build_template\|__spec_build_shell\|__spec_build_pre\|__spec_build_post\|__spec_build_custom_pre\|__spec_build_custom_post\|__spec_build_cmd\|__spec_build_body\|__spec_build_args\|__spec_autodep_template\|__spec_autodep_shell\|__spec_autodep_pre\|__spec_autodep_post\|__spec_autodep_custom_pre\|__spec_autodep_custom_post\|__spec_autodep_cmd\|__spec_autodep_body\|__spec_autodep_args\|__sed\|__rsh\|__rm\|__remsh\|__ranlib\|__python\|__pgp_verify_cmd\|__pgp_sign_cmd\|__pgp_check_password_cmd\|__pgp5_verify_cmd\|__pgp5_sign_cmd\|__pgp5_check_password_cmd\|__pgp\|__perl\|__patch\|__os_install_post\|__objdump\|__objcopy\|__nm\|__mv\|__mkdir_p\|__mkdir\|__make\|__ln_s\|__libtoolize\|__ld\|__install_info\|__install\|__id\|__gzip\|__grep\|__gpg_verify_cmd\|__gpg_sign_cmd\|__gpg_check_password_cmd\|__gpg\|__find_requires\|__find_provides\|__file\|__cxx\|__cpp\|__cpio\|__cp\|__chown\|__chmod\|__chgrp\|__cc\|__cat\|__bzip2\|__awk\|__automake\|__autoheader\|__autoconf\|__as\|__arch_install_post\|__ar\|__aclocal\)\>' skip='\\$' end='$' contains=specCommandOpts,specMacroIdentifier,specIf
syn region specMacroCommandLocalBracketed matchgroup=specSectionMacro start='%\@<!%{\(update_wms\|update_scrollkeeper\|update_menus\|uninstall_info\|strip_static\|strip_shared\|strip_relocatable\|strip_executable\|strip_binaries\|set_verify_elf_topdir\|set_verify_elf_skiplist\|set_verify_elf_method\|set_strip_topdir\|set_strip_skiplist\|set_strip_method\|set_perl_req_method\|set_libtool_version\|set_gcc_version\|set_fixup_topdir\|set_fixup_skiplist\|set_fixup_method\|set_findreq_topdir\|set_findreq_skiplist\|set_findprov_topdir\|set_findprov_skiplist\|set_compress_topdir\|set_compress_skiplist\|set_compress_method\|set_cleanup_topdir\|set_cleanup_skiplist\|set_cleanup_method\|set_automake_version\|set_autoconf_version\|remove_optflags\|preun_service\|postun_ldconfig\|post_service\|post_ldconfig_sys\|post_ldconfig_lib\|post_ldconfig\|make_session\|make_install\|make_compile\|make_build\|make\|install_info\|find_lang\|compress_docs\|cleanup_build\|clean_wms\|clean_scrollkeeper\|clean_menus\|clean_buildroot\|add_verify_elf_skiplist\|add_strip_skiplist\|add_serial\|add_optflags\|add_fixup_skiplist\|add_findreq_skiplist\|add_findprov_skiplist\|add_compress_skiplist\|add_cleanup_skiplist\|_update_wms_bin\|_update_scrollkeeper_bin\|_update_menus_bin\|_remove_install_info\|_make_bin\|_install_langs\|_install_info\|_fixperms\|_fixowner\|_fixgroup\|_defattr\|_configure_script\|__unzip\|__tar\|__subst\|__strip\|__ssh\|__spec_rmbuild_template\|__spec_rmbuild_shell\|__spec_rmbuild_pre\|__spec_rmbuild_post\|__spec_rmbuild_custom_pre\|__spec_rmbuild_custom_post\|__spec_rmbuild_cmd\|__spec_rmbuild_body\|__spec_rmbuild_args\|__spec_prep_template\|__spec_prep_shell\|__spec_prep_pre\|__spec_prep_post\|__spec_prep_custom_pre\|__spec_prep_custom_post\|__spec_prep_cmd\|__spec_prep_body\|__spec_prep_args\|__spec_install_template\|__spec_install_shell\|__spec_install_pre\|__spec_install_pre\|__spec_install_post\|__spec_install_custom_pre\|__spec_install_custom_post\|__spec_install_cmd\|__spec_install_body\|__spec_install_args\|__spec_clean_template\|__spec_clean_shell\|__spec_clean_pre\|__spec_clean_post\|__spec_clean_post\|__spec_clean_custom_pre\|__spec_clean_custom_post\|__spec_clean_cmd\|__spec_clean_body\|__spec_clean_args\|__spec_build_template\|__spec_build_shell\|__spec_build_pre\|__spec_build_post\|__spec_build_custom_pre\|__spec_build_custom_post\|__spec_build_cmd\|__spec_build_body\|__spec_build_args\|__spec_autodep_template\|__spec_autodep_shell\|__spec_autodep_pre\|__spec_autodep_post\|__spec_autodep_custom_pre\|__spec_autodep_custom_post\|__spec_autodep_cmd\|__spec_autodep_body\|__spec_autodep_args\|__sed\|__rsh\|__rm\|__remsh\|__ranlib\|__python\|__pgp_verify_cmd\|__pgp_sign_cmd\|__pgp_check_password_cmd\|__pgp5_verify_cmd\|__pgp5_sign_cmd\|__pgp5_check_password_cmd\|__pgp\|__perl\|__patch\|__os_install_post\|__objdump\|__objcopy\|__nm\|__mv\|__mkdir_p\|__mkdir\|__make\|__ln_s\|__libtoolize\|__ld\|__install_info\|__install\|__id\|__gzip\|__grep\|__gpg_verify_cmd\|__gpg_sign_cmd\|__gpg_check_password_cmd\|__gpg\|__find_requires\|__find_provides\|__file\|__cxx\|__cpp\|__cpio\|__cp\|__chown\|__chmod\|__chgrp\|__cc\|__cat\|__bzip2\|__awk\|__automake\|__autoheader\|__autoconf\|__as\|__arch_install_post\|__ar\|__aclocal\)\>}' skip='\\$' end='$' contains=specCommandOpts,specMacroIdentifier,specIf

"------------------------------------------------------------------------------
" here's is all the spec sections definitions: PreAmble, Description, Package,
"   Scripts, Files and Changelog

"One line macros - valid in all ScriptAreas
"tip: remember do include new items on specScriptArea's skip section
syn region specSectionMacroArea matchgroup=specSectionMacro start='^\s*%\(global\|define\|def_with\|def_without\|def_enable\|def_disable\|undefine\|patch\d*\|setup\|configure\|GNUconfigure\|find_lang\|makeinstall\)\>' skip='\\$' end='$' contains=specCommandOpts,specMacroIdentifier,specSpecialChar
syn region specSectionMacroBracketArea matchgroup=specSectionMacro start='^\s*%{\(configure\|GNUconfigure\|find_lang\|makeinstall\)}' skip='\\$' end='$' contains=specCommandOpts,specMacroIdentifier,specIf

"%% Files Section %%
"TODO %config valid parameters: missingok\|noreplace
"TODO %verify valid parameters: \(not\)\= \(md5\|atime\|...\)
syn region specFilesArea matchgroup=specSection start='^%files\>' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\|changelog\)\>'me=s-1 contains=specFilesOpts,specFilesDirective,@specListedFiles,specComment,specCommandSpecial,specMacroIdentifier,specIf
"tip: remember to include new itens in specFilesArea above
syn match  specFilesDirective contained '%\@<!%\(attrib\|defattr\|attr\|dir\|config\|docdir\|doc\|lang\|verify\|ghost\|exclude\)\>'

"valid options for certain section headers
syn match specDescriptionOpts contained '\s-[ln]\s*\a'ms=s+1,me=e-1
syn match specPackageOpts     contained    '\s-n\s*\w'ms=s+1,me=e-1
syn match specFilesOpts       contained    '\s-[fn]\s*\w'ms=s+1,me=e-1

syn case ignore

"%% PreAmble Section %%
"Copyright, Serial and BuildPreReq were deprecated by
"License,   Epoch  and BuildRequires
syn region specPreAmbleDeprecated oneline matchgroup=specError start='^\(Copyright\|Serial\|BuildRoot\)' end='$' contains=specEmail,specURL,specURLMacro,specLicense,specColon,specSpecialChar,@specVarsAll
syn region specPreAmble oneline matchgroup=specCommand start='^\(Prereq\|Summary\|Name\|Version\|Packager\|Requires\|Icon\|URL\|Source\d*\|Patch\d*\|Prefix\|Packager\|Group\|License\|Release\|Distribution\|Vendor\|Provides\|ExclusiveArch\|ExcludeArch\|ExclusiveOS\|Obsoletes\|BuildArch\|BuildArchitectures\|BuildRequires\|BuildConflicts\|BuildPreReq\|Conflicts\|AutoRequires\|AutoReq\|AutoReqProv\|AutoProv\|Epoch\)' end='$' contains=specEmail,specURL,specURLMacro,specLicense,specColon,specSpecialChar,@specVarsAll

"%% Description Section %%
syn region specDescriptionArea matchgroup=specSection start='^%description' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\)\>'me=s-1 contains=specDescriptionOpts,specEmail,specURL,specNumber,specAltNumber,specMacroIdentifier,specComment,specIf

"%% Package Section %%
syn region specPackageArea matchgroup=specSection start='^%package' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\)\>'me=s-1 contains=specPackageOpts,specPreAmble,specComment,specIf

"%% Scripts Section %%
syn region specScriptArea matchgroup=specSection start='^%\(prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\)\>' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\|changelog\)\>'me=s-1 contains=specIf,@specScriptAll,@specCommands,@shAll
syn region specScriptArea matchgroup=specSection start='^%\(prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\)\>' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\|changelog\)\>'me=s-1 contains=specIf,@specScriptAll,@specCommands,@shAll

"%% Changelog Section %%
syn region specChangelogArea matchgroup=specSection start='^%changelog' end='^%\(description\|package\|prep\|build\|buildmulti\|install\|clean\|pre\|postun\|preun\|post\|trigger\(in\|un\|postun\)\|files\)\>'me=s-1 contains=specEmail,specURL,specWeekday,specMonth,specNumber,specAltNumber,specComment,specLicense


"------------------------------------------------------------------------------
"here's the shell syntax for all the Script Sections

syn case match

"sh-like comment stile, only valid in script part
syn match shComment contained '#.*$'
syn match shSpecial contained '\\"'

" 1st: >= !=   2nd: > 2> <&- 2>&1    *the order is important, don't change
syn match shOperator contained '[!=><]=\|\(\W\d\)\=[><]\(&[0-9-]\)\='
"test's arithmetic literal operators
syn match shOperator contained '\s-\([lg][te]\|e[qf]\|n[et]\|ot\)\>'ms=s+1

syn region shQuote1 contained matchgroup=shQuoteDelim start=+'+ end=+'+ contains=specMacroIdentifier
syn region shQuote2 contained matchgroup=shQuoteDelim start=+"+ skip=+\\"+ end=+"+ contains=specVariables,specMacroIdentifier,shSpecial
syn region shHereDoc contained matchgroup=shQuoteDelim start='<<-\=\s*EOF$' end='^EOF' contains=specVariables,specMacroIdentifier,shSpecial

syn region shSubshell transparent contained matchgroup=shOperator start="`" skip="\\`" end="`" contains=@shAll,@specVarsAll,@specCommands,specSpecialChar
syn region shSubshell transparent contained matchgroup=shOperator start="$(" end=")" contains=@shAll,@specVarsAll,@specCommands,specSpecialChar

"why it's in the middle of shell part? just don't ask &:)
syn match  specIfKeys  contained '%\@<!%else\>'
syn region specIf      transparent matchgroup=specBlock start="%\@<!%\(if\>\|ifdef\|ifndef\|if_without\|if_with\|if_enabled\|if_disabled\|ifosf\|ifos\|ifnos\|ifarch\|ifnarch\)\>"  end='%\@<!%endif\>' contains=specIfKeys,@specScriptAll,@specSectionAll,specIf,specFilesDirective,specMacroCommand

syn keyword shIfKeys   contained then else elif
syn region  shIf       transparent matchgroup=specBlock start='^\<[ |	]*if\s'me=e-1 end='\<fi\>' contains=shIfKeys,@specScriptAll,specIf

syn keyword shDoKeys   contained in do
syn region  shDo       transparent matchgroup=specBlock start='^\<[ |	]*\(for\|while\|until\)\s'me=e-1 end='\<done\>' contains=shDoKeys,@specScriptAll,specIf

syn keyword shCaseKeys contained in
syn region  shCaseItem contained   matchgroup=specBlock start=')' end=';;' contains=@specScriptAll,specIf
syn region  shCase     transparent matchgroup=specBlock start='^\<[ |	]*case\s'me=e-1 end='\<esac\>' contains=shCaseKeys,shCaseItem,shComment,shSubshell,@specVarsAll


if !exists("did_spec_syntax_inits")
        let did_spec_syntax_inits = 1
        " The default methods for highlighting. Can be overridden later.

          "main types color definitions
          hi link specSection                   Structure
          hi link specSectionMacro              Macro
          hi link specWWWlink                   PreProc
          hi link specOpts                      Operator

          "yes, it's ugly, but white is sooo cool
          if &background == "dark"
            hi      specGlobalMacro            ctermfg=white guifg=white
          else
            hi link specGlobalMacro            Identifier
          endif

          "sh colors
          hi link shComment                     Comment
          hi link shSpecial                     Special
          hi link shIfKeys                      Function
          hi link shDoKeys                      Function
          hi link shCaseKeys                    Function
          hi link shOperator                    Special
          hi link shQuote1                      String
          hi link shQuote2                      String
          hi link shHereDoc                     String
          hi link shQuoteDelim                  Statement

          "spec colors
          hi link specBlock                     Function
          hi link specColon                     Special
          hi link specCommand                   Statement
          hi link specMacroCommandLocal		Statement
          hi link specCommandOpts               specOpts
          hi link specCommandSpecial            Special
          hi link specComment                   Comment
          hi link specConfigure                 specCommand
          hi link specDate                      String
          hi link specDescriptionOpts           specOpts
          hi link specEmail                     specWWWlink
          hi link specError                     Error
          hi link specFilesDirective            specSectionMacro
          hi link specFilesOpts                 specOpts
          hi link specIfKeys                    Function
          hi link specLicense                   String
	  hi link specMacroCommandDelim         Statement
	  hi link specMacroConditionalDelim     Structure
          hi link specMacroNameLocal            specGlobalMacro
          hi link specMacroNameOther            specGlobalMacro
          hi link specMacroIdentifier		Identifier
          hi link specManpageFile               NONE
          hi link specMonth                     specDate
          hi link specNumber                    Number
          hi link specPackageOpts               specOpts
          hi link specPercent                   Special
          hi link specSpecialChar               Special
          hi link specSpecialVariables          specGlobalMacro
          hi link specSpecialVariablesNames     specGlobalMacro
          hi link specTarCommand                specCommand
          hi link specURL                       specWWWlink
          hi link specURLMacro                  specWWWlink
          hi link specVariables                 Identifier
          hi link specWeekday                   specDate
          hi link specListedFilesBin            Statement
          hi link specListedFilesDoc            Statement
          hi link specListedFilesEtc            Statement
          hi link specListedFilesLib            Statement
          hi link specListedFilesPrefix         Statement
          hi link specListedFilesShare          Statement
  endif

let b:current_syntax = "spec"

" vim: ts=8
