#!/bin/sh -ef
# -*- mode: Shell-script; tab-width: 8; fill-column: 70; -*- 
# $Id: backend3.sh,v 0.0.1 2006/02/14 18:34:39 legion Exp $ 

userhandler() {  # trick to protect loop values
    local l= readmsg= params=
    local IFS="$IFS" PATH="$PATH" # Protected variables
    on_message ||: # ignore exit code of user actions
}

newline_decode()
{
    if [ "$1" != "_objects" ]; then
      local separator=$(printf '\007')
      sed  $sed_options "s,\\\\\(.\),$separator\1,g
	      s,${separator}n,\n,g
	      s,$separator,,g"
    else
      cat
    fi
}

message_loop() {
    local l= readmsg= params= name= value=
    while read -r l; do
	if [ "$l" != "${l#_message:begin}" ]; then 
	    readmsg=1
	    continue
	fi
	if [ -n "$readmsg" -a "$l" != "${l#_message:end}" ]; then
	    userhandler
	    readmsg=
	    [ -n "$params" ] && unset $params params ||:
	fi
	[ -n "$readmsg" ] || continue
	name="$(printf %s\\n "${l%%:*}" | sed -e 's,[^[:alnum:]_],,g')" && 
	value="$(printf %s\\n "${l#*:}" | newline_decode "$name" | sed -e 's/["$`\]/\\&/g' )" ||
    		continue
	eval "in_$name=\"$value\"" && params="$params in_$name" && name= value= ||:
    done
}
	    
simple_quote()
{
	sed 's,[\"],\\&,g'
}
