PO_NAME = alterator-$(NAME)
POT_NAME = po/$(PO_NAME).pot
PO_KEYWORD=_

SCM_TRANSLATE = $(shell find ui -name '*.scm') $(wildcard backend2/*)
SH_TRANSLATE = $(shell [ -d backend3 ] && for i in backend3/*; do file $$i|fgrep -qs 'shell script text' && echo $$i;done)

PO_FILES=$(wildcard po/*.po)
PO_LANGUAGES=$(PO_FILES:po/%.po=%)

LOCALEDIR=$(datadir)/locale

INSTALL=install
XGETTEXT=xgettext
MSGFMT=msgfmt
MSGMERGE=msgmerge

install-po:
	for i in $(PO_LANGUAGES); do \
	$(INSTALL) -d $(LOCALEDIR)/$$i/LC_MESSAGES; \
	$(MSGFMT) -o $(LOCALEDIR)/$$i/LC_MESSAGES/$(PO_NAME).mo po/$$i.po ;\
	done

scm-update-po:
	$(XGETTEXT)  --join-existing --add-comments -o$(POT_NAME) -L Lisp --keyword=$(PO_KEYWORD) $(SCM_TRANSLATE)

sh-update-po:
	$(XGETTEXT) --join-existing --add-comments -o$(POT_NAME) -L Shell --keyword=$(PO_KEYWORD) $(SH_TRANSLATE)

update-po:
	$(INSTALL) -d po
	$(RM) $(POT_NAME)
	touch $(POT_NAME)
	[ -n "$(SCM_TRANSLATE)" ] && make scm-update-po || :
	[ -n "$(SH_TRANSLATE)" ] && make sh-update-po || :
	for i in $(PO_LANGUAGES);do \
	$(MSGMERGE) po/$$i.po $(POT_NAME) -o $$.new.po && mv $$.new.po po/$$i.po; \
	done

build-po:
	$(INSTALL) -d po
	for i in $(PO_LANGUAGES); do \
	$(INSTALL) -d $(LOCALEDIR)/$$i/LC_MESSAGES; \
	$(MSGFMT) -o po/$$i.mo po/$$i.po ;\
	done

clean-po:
	$(RM) po/*.mo
