(define-module (alterator algo)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-11)
  :use-module (srfi srfi-2)
  :re-export (->bool)
  :export (use-local-files
           with-first-readable
	   read-access?
	   write-access?
           
	   eat-rest
	   
           cond-car
           cond-cadr
           cond-cdr

           sure-symbol
           begin-1
           thunk
	   compose

           append1
           list-exchange
           list-remove
	   list-flat

           alist-set
	   cond-assoc
	   cond-assq

           make-cell
           cell-set!
           cell-ref))

;description: some usefull algorithms, that I cannot find in srfi's

;;;;;;;;;;;;;;;;; read enchancements

;eat rest space characters from port
(define (eat-rest port)
  (let loop ()
    (and-let* ( ((char-ready? port))
                (char (peek-char port))
                ((char? char))
                ((char-whitespace? char)))
              (read-char port)
              (loop))))

;;;;;;;;;;;;;;;;;; common file selection
(define use-local-files (make-fluid))

(define (read-access? file)
  (and (string? file)
       (access? file R_OK)))

(define (write-access? file)
  (and (string? file)
       (access? file W_OK)))

(define (with-first-readable filelist proc)
  (let ((item (find read-access? filelist)))
    (and item (proc item))))
   
;;;;;;;;;;;;;;;;;;;conditional version of some operations

(define (cond-car key) (and (pair? key) (car key)))
(define (cond-cdr key) (and (pair? key) (cdr key)))
(define (cond-cadr key) (and (pair? key) (pair? (cdr key)) (cadr key)))

;;;;;;;;;;;;;;;;;symbols

(define (sure-symbol x)
  (cond
    ((symbol? x) x)
    ((macro? x) (macro-name x))
    ((string? x) (string->symbol x))
    (else (error "sure-symbol unsupported type for conversion" x))))

;;;;;;;;;;;;;;;;;;;lists
(define (append1 lst item)
   (append lst (list item)))

(define (list-remove lst num)
  (let-values (((head tail) (split-at lst num)))
    (append head (cdr tail))))

(define (list-exchange lst num)
  (let-values (( (head tail) (split-at lst num)))
    (append head
            (list (cadr tail) (car tail))
            (cddr tail))))

;helper to flat html: arguments, to made life easy
(define (list-flat args)
  (reverse
   (let loop ((args args)
              (result '()))
     (cond
      ((null? args)
       result)
      ((list? (car args))
       (loop (cdr args)
             (append (loop (car args) '()) result)))
      (else
       (loop (cdr args)
             (cons (car args) result)))))))

;;;;;;;;;;;;;;;syntatic sugar
(define (apply1 x y)
  (apply x y '()))
(define (compose . functions)
  (lambda(x)
    (fold-right apply1 x functions)))


;shortcut for simplest lambda 
(define-macro (thunk <first> . <next>)
    `(lambda() ,<first> . ,<next>))

;as a begin, but return result of 1st expression
(define-macro (begin-1 <first> . <next>)
  (let ((result (gensym)))
    `(let ((,result ,<first>))
       ,@<next>
       ,result)))

;;;;;;;;;;;;;;;alist functions
;we can use fold here, but we made a little optimization here
(define (alist-set name value alist)
  (let loop ((current alist)
             (result '()))
    (cond
     ((null? current) (append1 result (cons name value)))
     ((eq? name (caar current)) (append result (list (cons name value)) (cdr current)))
     (else (loop (cdr current) (append1 result (car current)))))))

(define (cond-assoc name alist . default)
  (cond
   ((assoc name alist) => cdr)
   (else (if (pair? default) (car default) #f))))

(define (cond-assq name alist . default)
  (cond
   ((assq name alist) => cdr)
   (else (if (pair? default) (car default) #f))))

;;;;;;;;;;;;;;;box and unbox

(define (make-cell value) (list value))
(define (cell-ref box) (car box))
(define (cell-set! box value) (set-car! box value))


;;;;;;;;;;;;;;; to boolean convertions
(define (->bool x) (not (not x)))
