(define-module (alterator configd constraints)
  :use-module (srfi srfi-2)
  :use-module (alterator str)
  :use-module (alterator plist)
  :use-module (alterator algo)
  :use-module (alterator woo)
  :use-module (alterator constraints)
  :use-module (alterator http html)
  :use-module (alterator http template)
  :export (fill-constraints))

(define (exclude->js excluded excluder value)
  (let ((excluded (->string excluded))
        (excluder (->string excluder))
        (value (->string value)))
    (string-append (format #f "if (!excludings[~S]) excludings[~S] = {};~%" excluded excluded)
                   (format #f "if (!excludings[~S][~S]) excludings[~S][~S] = [];~%"
                           excluded excluder
                           excluded excluder)
                   (format #f "excludings[~S][~S].push(~S);~%" excluded excluder value)
                   (format #f "excluders[~S]=1;~%" excluder))))

(define (required->js name)
  (format #f "required.push(~S);~%" (->string name)))

(define (constraints->js lst)
  (plist-map (lambda (name constraints)
               (plist-map (lambda(type params)
                            (case type
                              ((exclude)
                               (exclude->js (cadr params) name (car params)))
                              ((required)
			       (if params (required->js name) ""))
                              (else "")))
                          constraints))
             lst))

(define (fill-constraints action url . url-args)
  (woo-catch
   (thunk
    (let ((constraints (read-constraints action url url-args)))
      (list
       (tag: "label"
             (lambda(options content)
               (or (and-let* ((id (cond-assq 'for options))
                              (info (cond-plistq (string->symbol id) constraints)))
                             (cond-plistq 'label info))
                   content)))
       (tag: "head"
             (@ 'template-operation 'append-content)
             (html: "script" (@ 'src "/fbi/scripts/constraints.js"))
             (html: "script"
                    (format #f "var required=[];~%")
                    (format #f "var excludings={};~%")
                    (format #f "var excluders={};~%")
                    (constraints->js constraints))))))
   (lambda args '())))
