(define-module (alterator configd form)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-13)
  :use-module (alterator plist)
  :use-module (alterator algo)
  :use-module (alterator str)
  :use-module (alterator woo)
  :use-module (alterator constraints)
  :use-module (alterator http template)
  :use-module (alterator http html)
  :use-module (alterator configd html)
 :export (;;high level
          fill-form
          new-form
	  ;;low level
	  process-form))

;;;;;;;;;;;;;;

(define (fill-form obj-url . obj-args)
  (process-form (delay (apply woo-read-first obj-url obj-args))
                obj-url obj-args))

(define (get-defaults obj-url obj-args)
  (woo-catch
   (thunk
    (process-defaults
     (read-constraints "new" obj-url obj-args)
     '() ))
   (lambda args '() )))

(define (new-form obj-url . obj-args)
  (let ((fake-url (string-append obj-url "/.object")))
    (process-form (delay (cons fake-url (get-defaults obj-url obj-args)))
                  fake-url obj-args)))

(define (process-form obj obj-url obj-args . obj-sub-url)
  (let ((obj-sub-url (if (null? obj-sub-url) "" (car obj-sub-url))))
    (list
     (and (string-null? obj-sub-url) (process-tbody obj-url obj-args))
     (process-a obj)
     (process-span obj)
     (process-progress obj)
     (process-select obj obj-url obj-args obj-sub-url)
     (process-hidden obj obj-sub-url)
     (process-checkbox obj obj-sub-url)
     (process-radio obj obj-sub-url)
     (process-text obj obj-sub-url)
     (process-textarea obj obj-sub-url))))

;;;;;;;;;;;;;;

(define (get-value options obj . default)
  (let ((name (cond-assq 'name options "")))
    (apply woo-get-option (force obj) (string->symbol name) default)))

(define (other-option? x)
  (not (memq (car x) '(name value href))))

(define (tag-options options obj-sub-url)
  (let ((name (cond-assq 'name options "")))
    (acons 'name
           (if (string-null? obj-sub-url)
               name
               (string-append obj-sub-url ":" name))
          (filter other-option? options))))

(define (process-select obj obj-url obj-args obj-sub-url)
  (replace-tag: "select"
                (lambda (options content)
                  (let* ((optionlist (cond-assq 'optionlist options))
                         (variants (if (string? optionlist)
                                       (apply woo-list (string-append obj-url "/" optionlist) obj-args)
                                       '())))
                    `(select ,@(tag-options options obj-sub-url)
                             ,(html:select-options (get-value options obj) variants))))))

;;note: autoskip "index" in path
(define (process-a obj)
  (list
   (replace-tag: "a"
                 (@ 'class "alterator-ref2")
                 (lambda (options content)
                   (let ((obj (basename (car (force obj))))
                         (url (cond-assq 'href options)))
                     `(local:a ,(@ 'href (string-append url obj))
                               ,(@ 'href2 url)
                               ,@(filter other-option? options)
                               ,@content))))
   (replace-tag: "a"
                 (@ 'class "alterator-ref")
                 (lambda(options content)
                   (let ((obj (car (force obj)))
                         (url (cond-assq 'href options)))
                     `(local:a ,(@ 'href (string-append obj url))
                               ,(@ 'href2 url)
                               ,@(filter other-option? options)
                               ,@content))))))

(define (process-span obj)
  (replace-tag: "span"
                (@ 'class "alterator-label")
                (lambda(options content)
		  `(span ,@options ,(->string (get-value options obj))))))

(define (process-progress obj)
  (replace-tag: "div"
                (@ 'class "alterator-progress")
                (lambda(options content)
                  `(div ,@options
                        ,(html: "div"
                                (@ 'class "alterator-progress-slider")
                                (@ 'style (format #f "width:~A%" (get-value options obj))))))))

(define (process-hidden obj obj-sub-url)
  (replace-tag: "input"
                (@ 'type "hidden")
                (lambda (options content)
                  `(input ,@(tag-options options obj-sub-url)
                          (value . ,(->string (get-value options obj)))))))

(define (process-checkbox obj obj-sub-url)
  (replace-tag: "input"
                (@ 'type "checkbox")
                (lambda (options content)
                  `(input ,@(tag-options options obj-sub-url)
                          ,(if (get-value options obj #f) (@ 'checked "yes") "")
                          (value . "#t")))))

(define (process-radio obj obj-sub-url)
  (replace-tag: "input"
                (@ 'type "radio")
                (lambda(options content)
                  `(input ,@(tag-options options obj-sub-url)))))

(define (process-text obj obj-sub-url)
  (replace-tag: "input"
                (@ 'type "text")
                (lambda(options content)
                  `(input ,@(tag-options options obj-sub-url)
                          (value . ,(get-value options obj) )))))

(define (process-textarea obj obj-sub-url)
  (replace-tag: "textarea"
                (lambda(options content)
                  `(textarea ,@(tag-options options obj-sub-url)
                             ,(get-value options obj) ))))

(define (fill-row row obj parent-url obj-url obj-args)
  (scm-filter
   row
   (make-cb (process-form obj (string-append parent-url "/" obj-url) obj-args obj-url))))

(define (process-tbody obj-url obj-args)
  (replace-tag: "tbody"
                (@ 'class "alterator-list")
                (lambda(options content)
                  (let* ((optionlist (cond-assq 'optionlist options ""))
                         (variants  (apply woo-list (string-append obj-url "/" optionlist) obj-args)))
                  `(tbody ,@options
                          ,@(map (lambda(obj)
                                   (fill-row content
                                             (delay obj)
					     obj-url
                                             (string-append optionlist
                                                            "/"
                                                            (cond-plistq 'name (cdr obj)))
					     obj-args))
                                 variants))))))
