(define-module (alterator configd frontend)
  :use-module (srfi srfi-13)
  :use-module (alterator str)
  :use-module (alterator algo)
  :export (design-path
	   base-path))

(define *system-template-dir* "/var/www/html/fbi/")
(define *local-template-dir* "html/fbi/")

(define (absolute-path? url)
  (and (not-empty-string? url)
       (char=? #\/ (string-ref url 0))))

(define (relative-path? url)
  (not (absolute-path? url)))

(define (design-path url)
   (let* ((system-url (if (relative-path? url)
                          (string-append *system-template-dir* url)
                          url))
          (local-url (and (relative-path? url)
                          (fluid-ref use-local-files)
                          (string-append *local-template-dir* url))))
     (with-first-readable
      (list local-url system-url) values)))

(define (base-path url)
  (let* ((url (string-trim-both url #\/))
         (start (and (not (string-null? url)) (string-index url #\/ 0))))
    (substring url 0 (or start (string-length url)))))
