(define-module (alterator configd html)
  :use-module (alterator woo)
  :use-module (alterator str)
  :use-module (alterator algo)
  :use-module (alterator gettext)
  
  :use-module (alterator http html)
  :use-module (alterator http template)
  :export (html:hidden
           html:submit
	   html:select-options
           html:select-option-value
           html:select-option-label
	   html:select
	   
	   html:error
           html:exception
	   
	   html:redirect))

(define (html:hidden name value)
  (html: "input"
         (@ 'name (->string name))
         (@ 'type "hidden")
         (@ 'value value)))

(define (html:submit name value . args)
  (apply html: "input"
         (@ 'name (->string name))
         (@ 'type "submit")
	 (@ 'class "btn")
         (@ 'value value) args))

(define (html:selected current value)
  (if (string=? value current)
      (@ 'selected "true")
      ""))

(define (html:select-option-value x)
  (woo-get-option x 'name))

(define (html:select-option-label x)
  (woo-get-option x 'label (html:select-option-value x)))

(define (html:select-options value variants)
  ;;auto select first item
  (let ((selected (if (and (string-null? value)
                           (pair? variants))
                      (html:select-option-value (car variants))
                      value)))
    (map (lambda(current)
           (let ((label (html:select-option-label current))
                 (value (html:select-option-value current)))
             (html: "option"
                    (@ 'value value)
                    (html:selected selected value)
                    label)))
           variants)))

(define (html:select name value options)
  (html: "select"
         (@ 'name (symbol->string name))
	 ,(html:select-options value variants)))

;; error and exception processing
(define (html:error-message reason)
  (html: "div" (@ 'class "error-message")
         (html: "pre" reason)))                

(define (html:error scm reason)
  (scm-filter
   scm
   (make-cb
    (replace-tag: "h1"
                  (lambda (options content)
                    `((h1 ,@options ,@content)
                      ,(html:error-message reason)))))))

;; exception processing
(define (html:exception url-args)
  (lambda (key . args)
    (let ((_ (make-translator "alterator-fbi"
                              (cond-assoc "language" url-args '("en_US")))))
      (template "/var/www/html/fbi/error.html"
                (tag: "h1" (_ "Error"))
                (tag: "div"
                      (@ 'class "error-message")
                      (case key
                        ((woo-error)
                         (list (_ "Backend") (html: "pre" (car args))))
                        ((xml-error)
                         (list (_ "XML Parser") ":" (car args)))
                        ((system-error)
                         (list (_ "System error") ":" (strerror (system-error-errno (cons key args)))))
                        (else
                         (format #f "key=~S,args=~S" key args))))))))

(define (html:redirect new-url . args)
  `(redirect ,new-url))
