(define-module (alterator configd woo)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-11)
  :use-module (srfi srfi-13)
  :use-module (alterator algo)
  :use-module (alterator plist)
  :use-module (alterator str)
  :use-module (alterator woo)
  :use-module (alterator http html)
  :use-module (alterator http template)
  :export (;;high level
           woo-template
	   woo-args
           ))

(define (template-backend url)
  (string-append "/template-" (string-trim url #\/)))

(define (template-args url-args)
  (let ((action (cond-assoc "action" url-args "unknown")))
    (cons* 'orig_action action (alist->plist (filter-args url-args)))))

(define (woo-template url . args)
  (let ((result (apply woo-try "template" (template-backend url) (template-args args))))
    (if (and (pair? result) (pair? (car result)))
        (plist->alist (cdar result))
        (woo-throw "No template information provided by backend:"))))

(define (true-string? value)
  (and (string? value) (string=? value "#t")))
(define (false-string? value)
  (and (string? value) (string=? value "#f")))

(define (filter-args lst)
  (filter-map (lambda(arg)
                (let ((name (car arg))
                      (value (cdr arg)))
                  (cond
                   ((empty-string? value) #f)
                   ((member name '("action" "language")) #f)
                   ((true-string? value) (cons name #t))
                   ((false-string? value) (cons name #f))
                   (else (cons name value)))))
              lst))

(define (extract-names url)
  (lambda(lst)
    (map (lambda(arg)
           (let* ((name (string-cut (car arg) #\:))
                  (value (cdr arg)))
             (if (= (length name) 1)
               (list url (string->symbol (car name)) value)
               (list (string-append url (car name)) (string->symbol (cadr name)) value))))
         lst)))

(define (same-id? id)
  (lambda(x)
    (string=? (car x) id)))

(define (merge-cmd cmd out-cmds language)
  (fold (lambda (other rest)
          (cons* (car rest) (cadr other) (caddr other) (cdr rest)))
        (cons* (car cmd) 'language language (cdr cmd))
        out-cmds))

;;split args into the groups for the different objects
(define (split-args language)
  (lambda(lst)
    (let loop ((result '())
               (rest lst))
      (if (null? rest)
          (reverse result)
          (let*-values (( (cmd) (car rest) )
                        ( (out-cmds out-rest) (partition (same-id? (car cmd)) (cdr rest)) ))
            (loop (cons (merge-cmd cmd out-cmds language) result)
                  out-rest))))))

(define (merge-arg first args)
  (cons (car first)
        (if (pair? args)
            (cons (cdr first) (map cdr args))
            (cdr first))))

;;join args with same names into array
(define (join-args lst)
  (let loop ((result '())
             (rest lst))
    (if (null? rest)
        (reverse result)
        (let*-values (( (first) (car rest) )
                      ( (out-merge out-rest) (partition (same-id? (car first)) (cdr rest)) ))
          (loop (cons (merge-arg first out-merge) result)
                out-rest)))))

(define (woo-args url args)
  (let* ((language (cond-assoc "language" args '("en_US")))
         (result  ((compose (split-args language)
                            (extract-names url)
			    join-args
                            filter-args) args)))
    (if (null? result)
        `((,url language ,language))
        result)))

