(define-module (alterator constraints)
  :use-module (ice-9 regex)

  :use-module (srfi srfi-1)
  :use-module (srfi srfi-11)
  :use-module (srfi srfi-13)
  
  :use-module (alterator gettext)
  :use-module (alterator object)
  :use-module (alterator str)
  :use-module (alterator plist)
  :use-module (alterator algo)
  :use-module (alterator woo)

  :export (read-constraints
           process-defaults

           woo-try/constraints

           woo-write/constraints
           woo-new/constraints
           woo-delete/constraints))

(define (read-constraints action name args)
  (woo-catch
   (thunk (or (cond-cdr (woo-first-command (apply woo-try
                                                  "constraints"
                                                  name
                                                  (cons* 'orig_action action args))))
              '()))
   (lambda args '() )))

;;;;;;;;;;;;;;;;; defaults

(define (get-defaults value constraints)
  (if (pair? value)
      #f
      (plistq 'default constraints)))

(define (default-args name value args)
  (if (pair? value)
      (cons* name (cdr value) args)
      args))

(define (process-defaults constraints args)
  (plist-fold (lambda (name constraints args)
                (let* ((value (get-defaults  (plistq name args)  constraints)))
                  (default-args name value args)))
               args
               constraints))

(define (woo-try/constraints action name . args)
  (let ((new-name (if (pair? name)
                      (cons "constraints" name)
                      (string-append "/constraints/" name))))
    (apply woo-try action new-name args)))

(define (woo-write/constraints name . args)
  (apply woo-try/constraints "write" name args))

(define (woo-new/constraints name . args)
  (apply woo-try/constraints "new" name args))

(define (woo-delete/constraints name . args)
  (apply woo-try/constraints "delete" name args))
