(define-module (alterator context)
  :use-module (srfi srfi-1)
  :use-module (alterator algo)
  :export (lookout-context
           change-context
           from-context
           with-context

           with-changed-context))

;;dialog's context may contains:
;; * current goto-frame
;; * current stack of globals
;; * current ids , etc.

(define lookout-context (make-fluid))
(fluid-set! lookout-context '())

(define (change-context name value)
  (alist-set name value (fluid-ref lookout-context)))

(define (from-context name)
  (cond-cdr (assq name (fluid-ref lookout-context))))

(define-macro (with-context <ctxt> <instruction> . <instructions>)
  `(with-fluids ((lookout-context ,<ctxt>))
                ,<instruction> . ,<instructions>))

(define-macro (with-changed-context <name> <value> <instruction> . <instructions>)
  `(with-fluids ((lookout-context (change-context ,<name> ,<value>)))
                ,<instruction> . ,<instructions>))
