(define-module (alterator css-embed)

  :use-module (ice-9 rdelim)
  :use-module (srfi srfi-2)
  :use-module (srfi srfi-13)

  :use-module (alterator str)
  :use-module (alterator algo)

  :use-module (alterator http html)
  :use-module (alterator http template)

  :export (css-embed))

(define *html-root* "/var/www/html/")

(define (make-path x)
  (and-let* ( ((string? x))
              (x (string-cut-repeated x #\/))
              ((not (null? x)))
              ((not (member ".." x)))
              (x (string-append *html-root* (string-join x "/")))
              ((read-access? x)) )
            x))

(define (path-content path)
  (call-with-input-file
      path
    (lambda(port)
     (let loop ((line (read-line port))
                 (result '()))
       (if (eof-object? line)
           (reverse result)
           (loop (read-line port) (cons line result)))))))

(define (link-embed options content)
  (or  (and-let* ((href (cond-assoc 'href options))
                  (path (make-path href)))
                 `(style ,@(path-content path)))
       ""))

(define (css-embed)
  (lambda (cmds next)
    (let ((scm (next cmds)))
      (scm-filter
       scm
       (make-cb
         (replace-tag: "link"
                       (@ 'type "text/css")
                       (@ 'rel "stylesheet")
                       link-embed))))))

