(define-module (alterator daemonize)
    :export (daemonize))
		    
(define (father)
  (primitive-exit 0))

(define (child logfile)
  (setsid)
  (chdir "/")

  ;note: don't close all ports, we need a port with script content
  (close-port (current-input-port))
  (close-port (current-output-port))
  (redirect-port (open-output-file logfile) (current-error-port))
  (chmod logfile #o600))

(define (daemonize logfile)
  (let ((pid (primitive-fork)))
    (cond
     ((zero? pid) (child logfile))
     ((positive? pid) (father))
     (else (error "unable to fork")))))
