;;TODO: add with-locked-file
(define-module (alterator ensign backend3)
	       :use-module (ice-9 rdelim)
	       :use-module (srfi srfi-13)
	       :use-module (alterator pipe)
	       :use-module (alterator plist)
	       :use-module (alterator algo)
	       :use-module (alterator str)
	       :use-module (alterator object)
	       :export (make-backend3))

;; backend3 - improved external backend system, next generation of barnacle

(define (newline-string-quote str)
  (string-quote (lambda (ch)
                  (case ch
                    ((#\cr) "")
                    ((#\newline) (string #\\ #\n))
		    ((#\\) (string #\\ #\\))
                    (else (string ch))))
                str))

(define (make-name objects)
  (if (null? objects)
      "/"
      (string-join (map newline-string-quote objects) "/")))

(define (flat-arg x)
  (if (list? x) (string-join x ";") x))

(define (communicate process objects options)
  (catch #t
    (thunk
     (let ((options (map flat-arg options))
           (i-port (port-for-read process))
           (o-port (port-for-write process)))
       ;;first output options to process
       (with-ignored-sigpipe
        (thunk
         (display "_message:begin" o-port)
         (newline o-port)
         (display "_objects:" o-port)
         (display (make-name objects) o-port)
         (newline o-port)
         (plist-for-each (lambda (name value)
                           (display name o-port)
                           (display ":" o-port)
                           (display (newline-string-quote (->string value)) o-port)
                           (newline o-port))
                         options)
         (display "_message:end" o-port)
         (newline o-port)
         (force-output o-port)))
       ;;then read answer
       (let ((answer (read i-port)))
         (if (eof-object? answer)
             '(error "unexpected eof from backend")
             answer))))
    (lambda (key . args)
      `(error ,(format #f "problem during backend communication=~S,~S" key args)))))

   
(define (real-make-backend3 script)
  (let ((process (create-process 'read-write script)))
    (object
     (lambda (self objects options)
       (communicate process objects options))
     ((quit self . args)
      (stop-process 'terminate process)
      #t))))


(define *system-backend-dir* "/usr/lib/alterator/backend3/")
(define *local-backend-dir* "backend3/")

(define (make-backend3 name)
  (let ((system-backend (string-append *system-backend-dir* name))
        (local-backend (and (fluid-ref use-local-files)
                            (string-append *local-backend-dir* name))))
    (with-first-readable
     (list local-backend system-backend) real-make-backend3)))

