;decription: barnacle - old mariner (support for non-native woobus backend format)
;Note: in this version I've allowed to write to directories.
;Note: 'new action is same as 'write but with exitance checking
;TODO: add with-locked-file
(define-module (alterator ensign barnacle)
	       :use-module (ice-9 rdelim)
	       :use-module (srfi srfi-1)
	       :use-module (srfi srfi-13)
	       :use-module (alterator pipe)
	       :use-module (alterator plist)
	       :use-module (alterator algo)
	       :use-module (alterator str)
	       :use-module (alterator object)
	       :export (make-barnacle))

;decription: barnacle - old mariner (support for non-native woobus backend format)
;Note: in this version I've allowed to write to directories.
;Note: 'new action is same as 'write but with exitance checking
;TODO: add with-locked-file

;general helper functions
(define (read-fold proc initial . args)
  (let ((port (if (null? args) (current-input-port) (car args))))
    (let loop ((line (read-line port))
	       (result initial))
      (if (eof-object? line)
          result
          (loop (read-line port) (proc line result))))))

(define (name-from-answer answer)
  (substring answer 0 (or (string-index-right answer #\space) (string-length answer))))

(define (args-from-answer answer)
  (let ((pos (string-index answer #\:)))
    (if pos
      (cons (substring answer 0 pos)
	    (substring answer (+ pos 1) (string-length answer)))
      (error "wrong answer from backend, : separator not found" answer))))

;actions helpers

(define (do-read-list port)
  (read-fold (lambda (x res) (cons (list (name-from-answer x)) res)) '() port))

(define (do-read-info port)
  (read-fold (lambda (x res)
               (if (string=? x "")
	            res
	           (let ((splited (args-from-answer x)))
		    (cons (string->symbol (car splited)) (cons (cdr splited) res))))) '() port))

;general wrapper for input functions
(define (do-in script object-name option proc)
  (define (combine process result)
    (cons (stop-process 'wait process) result))
  (let ((process (create-process 'read-only script option object-name)))
    (combine process (proc (cadr process)))))

(define (do-out script object-name args)
  ;we have made a sigpipe protected output to backend, and , therefore, ignore possible problems 
  ;in backends. it's possible we will return a error message in the future
  (let ((outport (create-process 'write-only script "-w" object-name)))
    (catch #t
	   (thunk
	     (with-ignored-sigpipe
	       (thunk
		 (and (pair? args)
		      (display
			(string-join
			  (map (lambda (x)
				 (format #f "~A:~A~%" (car x) (cdr x)))
			       args)
			  "")
			(caddr outport)))
		 (stop-process 'wait outport))))
	   (lambda (key . args)
	     (stop-process 'terminate outport)))))

(define (out-answer result good-message error-message)
  (cond
   ((eq? result #f) '(error "process terminated abnormally"))
   ((zero? result) good-message)
   (else `(error ,error-message))))

(define (do-delete script object-name)
  (out-answer (stop-process 'wait (create-process 'read-only script "-d" object-name))
              '()
              "object was not deleted"))

(define (flat-arg x)
  (if (list? x) (string-join x ";") x))

(define (exclude-action lst)
  (let ((lst (plist->alist (map flat-arg lst))))
    (filter (lambda(item) (not (member (car item) '(action language))) )
            lst)))

(define (real-make-barnacle script)
  (define (make-url objects)
    (string-join (if (null? objects) '("/") objects) "/"))
  (object
   #f
   ((list self objects options)
    (let ((result (do-in script (make-url objects) "-l" do-read-list)))
      (out-answer (car result)
                  (cdr result)
                  "list action failed")))
   ((read self objects options)
    (let ((result (do-in script (make-url objects) "-r" do-read-info)))
      (out-answer (car result)
                  (cdr result)
                  "read action failed")))
   ((write self objects options)
    (out-answer  (do-out script (make-url objects) (exclude-action options))
                 '()
                 "write action failed"))
   ((new self objects options)
    (out-answer (do-out script (make-url objects) (exclude-action options))
                '()
                "object was not created"))
   ((delete self objects options) (do-delete script (make-url objects)))))


(define *system-backend-dir* "/usr/lib/alterator/backend/")
(define *local-backend-dir* "backend/")

(define (make-barnacle name)
  (let ((system-backend (string-append *system-backend-dir* name))
        (local-backend (and (fluid-ref use-local-files)
                            (string-append *local-backend-dir* name))))
    (with-first-readable
     (list local-backend system-backend) real-make-barnacle)))

