;;ensign manager
(define-module (alterator ensign ensign)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator plist)
	       :use-module (alterator object)

               :use-module (alterator gettext)
	       :export (make-ensign))

(define (stop-backend backend)
  (run-operation (cadr backend) 'quit #t))

(define (make-ensign mariners clean-interval)
  (object
   #f
   ;;clean interval
   ((constraints self objects options)
    (let ((_ (make-translator "alterator" (cond-plistq 'language options '("en")))))
      `(clean-interval (label ,(_ "Backend live time (in hours)")
                              match ("^[[:digit:]]+$" ,(_ "should be digits"))))))
   ((read self objects options)
    (list 'clean-interval (number->string (/ (cell-ref clean-interval) 60 60))))
   ((write self objects options)
    (let ((interval (cond-plistq 'clean-interval options)))
      (and (string? interval) (cell-set! clean-interval (* 60 60 (string->number interval)))))
      '())
   ;;protect from exit
   ((quit . args)
    #f)
   ;;unload backends
   ((delete self objects options)
    (and (pair? objects)
         (let* ((name (car objects))
                (backends (cell-ref mariners))
                (backend (assoc name backends)))
           (and backend
                (stop-backend backend)
                (cell-set! mariners (alist-delete name backends)))))
      '())
   ((list self objects options)
    (map (compose list car) (cell-ref mariners)))))

