(define-module (alterator ensign midshipman)
	       :use-module (alterator algo)

	       :use-module (alterator security wrap)
	       :use-module (alterator ensign evaluation)

	       :export (make-midshipman))

(define (load-midshipman path)
  (call-with-input-file
      path
    (lambda(port)
      (let loop ((instruction (read port))
                 (result '()))
        (if (eof-object? instruction)
            (reverse result)
            (loop (read port) (cons instruction result)))))))

(define (real-make-midshipman script)
    (ensign-eval
     (apply backend->toplevel-begin
            (load-midshipman script))))

(define *system-backend-dir* "/usr/lib/alterator/backend2/")
(define *local-backend-dir* "backend2/")

(define (make-midshipman name)
  (let ((system-backend (string-append *system-backend-dir* name))
        (local-backend (and (fluid-ref use-local-files)
                            (string-append *local-backend-dir* name))))
    (with-first-readable
     (list local-backend system-backend) real-make-midshipman)))
