(define-module (alterator exit-handler)
  :export (with-exit-handler
           at-exit))


(define *handlers* '())

(define (at-exit proc) (set! *handlers* (cons proc *handlers*)))

(define (run-at-exit)
  (for-each (lambda(x) (x)) *handlers*))

(define (with-exit-handler proc)
  (catch
      #t
    proc
    (lambda args
      (run-at-exit)
      (apply throw args)))
  (run-at-exit))
