(define-module (alterator gettext)
  :use-module (srfi srfi-1)
  :use-module (alterator algo)
  :use-module (alterator str)
  :export (make-translator))

(dynamic-call "scm_init_gettext"
	      (dynamic-link "libguile-gettext.so"))

;;create path like /usr/share/locale/ru/LC_MESSAGE/package.mo
(define (make-system-path item package)
  (string-append "/usr/share/locale/" item "/LC_MESSAGES/" package ".mo"))

;;create path like po/ru.mo
(define (make-local-path item)
  (and (fluid-ref use-local-files)
       (string-append "po/" item ".mo")))

(define (search-mo package candidates)
  (find read-access?
        (fold (lambda (x y);;made full-path, both for local and global paths
                (append y
                        (list (make-local-path x)
                              (make-system-path x package))))
              '()
              (fold (lambda (x y) ;;append short names to expand searching
                          (append y (list x (safe-substring x 0 2))))
                    '()
                    candidates))))

(define (make-dictionary mo-path)
  (let ((dict (make-hash-table 10)))
    (for-each (lambda (item)
                (hash-set! dict (car item) (cdr item)))
              (or (load-mo mo-path) '()))
    dict))

(define (search-dictionary word dict)
  (hash-ref dict word word))

(define (make-translator package candidates)
  (let* ((full-path (search-mo package candidates))
         (dictionary (and full-path (make-dictionary full-path))))
    (lambda (str)
      (if dictionary
          (search-dictionary str dictionary)
          str))))
