;helper functions to work with cgi/fastcgi interface
(define-module (alterator http html)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-11)
  :use-module (srfi srfi-13)
  :use-module (alterator str)
  :use-module (alterator algo)
  :export (@ html: html:quote))

(define @ cons)

(define (html:quote str)
  (string-quote (lambda (ch)
		  (case ch
		    ((#\&) "&amp;")
		    ((#\') "&apos;")
		    ((#\") "&quot;")
		    ((#\<) "&lt;")
		    ((#\>) "&gt;")
		    (else (string ch))))
		str))

(define (html: tag . args)
  `(,(sure-symbol tag) ,@args))
