(define-module (alterator http locale)
  :use-module (srfi srfi-13)
  :use-module (alterator str)
  :use-module (alterator algo)
  :export (code->locale))

(define default-lang '(("ru" . "ru")
                       ("uk" . "ua")
                       ("en" . "us")
                       ("be" . "by")))

(define (country-for-lang lang)
  (cond-assoc lang default-lang lang))

(define (code->locale x)
  (let* ((x (string-cut x #\-))
         (language (cond-car x))
         (country (or (cond-cadr x) (country-for-lang language))))
    (string-append
     (string-downcase language) "_" (string-upcase country))))
