;description: woobus module to log all bus messages to file
(define-module (alterator logfile)
	       :use-module (alterator ports)
	       :use-module (alterator str)
	       :export ( logfile ))

(define (logfile-write cmds write-empty write-cmd)
	(if (null? cmds)
	  (write-empty)
	  (for-each write-cmd cmds)))

(define (logfile-forward logfile cmds)
  (define (logfile-command cmd) (write cmd logfile) (newline logfile))
  (define (logfile-empty) (display ";question: empty" logfile) (newline logfile))
  (logfile-write cmds logfile-empty logfile-command)
  (force-output logfile)
  cmds)

(define (logfile-backward logfile cmds)
  (define (logfile-command cmd) (display (format #f ";answer: ~S~%" cmd) logfile))
  (define (logfile-empty) (display ";answer: empty" logfile) (newline logfile))
  (logfile-write cmds logfile-empty logfile-command)
  (force-output logfile)
  cmds)

(define (logfile-timestamp logfile)
  (display (format #f ";log started at ~A~%"
		   (strftime "%c" (localtime (current-time))))
	   logfile))

(define (logfile filename)
  (let ((logfile (open-file filename "w")))
    (logfile-timestamp logfile)
    (lambda (cmds next)
	(logfile-backward
         logfile
         (next (logfile-forward logfile cmds))))))
