(define-module (alterator lookout evaluation)

  ;;std modules
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-2)
  :use-module (srfi srfi-11)
  :use-module (srfi srfi-13)

  :use-module (ice-9 regex)
  :use-module (ice-9 pretty-print)

  ;;common extentions
  :use-module (alterator gettext)
  :use-module (alterator glob)

  ;;common helper modules
  :use-module (alterator r6rs)
  :use-module (alterator container)
  :use-module (alterator vector)
  :use-module (alterator object)
  :use-module (alterator gettext)
  :use-module (alterator glob)
  :use-module (alterator str)
  :use-module (alterator plist)
  :use-module (alterator algo)
  :use-module (alterator woo)
  :use-module (alterator constraints)
  :use-module (alterator context)
  :use-module (alterator atlas)

  ;;simplest message passing
  :use-module (alterator mailbox)

  ;;for toplevel-begin
  :use-module (alterator security wrap)

  ;;presentation engines
  :use-module (alterator presentation common)
  :use-module (alterator presentation document)
  :use-module (alterator presentation container)
  :use-module (alterator presentation events)
  
  ;;session gate
  :use-module (alterator session common)
	     
  ;;lookout: need for correct eval
  :use-module (alterator lookout presentation)
  :use-module (alterator lookout root)
  :use-module (alterator lookout ident)
  :use-module (alterator lookout globals)
  :use-module (alterator lookout goto)

  :export (document:eval))

;;;;;;;;;;;;;;;
(define-macro (with-translation <prefix> <textdomain> <instruction> . <instructions>)
          `(let ((,<prefix> (make-translator
                             ,<textdomain>
			     (session-language) )))
                ,<instruction> . ,<instructions>))

;;;;;;;;;;;;;;;

(define real-current-module (current-module))

(define (document:error . args) (error "try to use insecure function"))

;shield insecure functions like set!
(define (shield-insecure lst)
  (let ((insecure-vars '(set! load use-modules open-output-file
 			  open-file delete-file
			  eval with-output-to-file call-with-output-file
			  module-obarray-set!)))
    `(let ,(map (lambda (x) `(,x document:error)) insecure-vars) ,@lst)))

(define (document:eval path)
  (eval  (shield-ids
	   (shield-insecure
	     (preprocess-file path))) real-current-module))
