(define-module (alterator lookout goto)
  :use-module (ice-9 rdelim)

  :use-module (srfi srfi-2)

  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator context)
  :use-module (alterator atlas)

  :use-module (alterator presentation common)
  :use-module (alterator presentation container)

  :use-module (alterator session common)

  :use-module (alterator lookout globals)
  :use-module (alterator lookout evaluation)

  :export (document:replace
           document:replace-in-widget
           
           clean-widget))

(define (clean-widget widget . thunk)
  (define-operation delete-subwidgets #f)
  (define-operation clear-events #f)
  (define-operation recreate-subwidgets)
  (define-operation recreate-attrs)
  (define-operation message-on)
  (define-operation message-off)
  (define-operation call)
  (define-operation no-messages?)
  
  (simple-notify widget 'action "clean")
  (delete-subwidgets widget)
  (clear-events widget)
  (or (null? thunk)
      (begin (without-notifications ((car thunk)));;major widget modifications here

             (recreate-attrs widget)
             (recreate-subwidgets widget)

             (or (no-messages? (fluid-ref generic-session))
	         (call widget (make-attribute 'loaded))))))

(define (replace-globals new)
  (let ((old-sub (global 'document:subdocument))
        (old-root (global 'document:root))
        (old-loop (global 'document:loop))
        (old-popup (global 'document:popup)))
    (reset-globals! new)
    (set-global! 'document:subdocument old-sub)
    (set-global! 'document:root old-root)
    (set-global! 'document:loop old-loop)
    (set-global! 'document:popup old-popup)))

(define (document:replace-in-widget widget . url)
  (define-operation params-of)
  (define-operation get-context)
  (define-operation call)
  
  (and-let* ((path (apply (from-context 'atlas) url)))
            ;;work with widget's context and it's globals
            (with-context (get-context widget)
                          (clean-widget widget
                                        (thunk
                                         (replace-globals (params-of path))
                                         (widget (document:eval path)))))))



(define (document:replace . url)
  (apply document:replace-in-widget
         (global 'document:subdocument) url))
