(define-module (alterator lookout ident)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator object)
	       :use-module (alterator presentation common)

               :export (shield-ids id-let document:id))


(define (make-self-destroyer name)
  `(,name (lambda (item) (set! ,name item))))

(define-macro (id-let <itemlist> . <body>)
  `(letrec ,(map make-self-destroyer <itemlist>) ,@<body>))

;collect all ids in document
(define (collect-ids lst)
  (fold (lambda (item collection)
	  (if (and (list? item) (pair? item))
	      (append collection
		      (collect-ids item);first possible subitems
		      (if (eq? (car item) 'document:id) (list (cadr item)) '()))
	      collection))
	'()
	lst))

;shield ids in document
(define (shield-ids lst)
  (let* ((ids (collect-ids lst)))
    (if (null? ids) lst `(id-let ,ids ,lst))))

(define (document:id id widget)
	(id widget)
	widget)
