(define-module (alterator lookout presentation)
  :use-module (srfi srfi-1)

  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator context)
  :use-module (alterator atlas)

  :use-module (alterator session common)
  :use-module (alterator presentation common)
  :use-module (alterator presentation container)


  :use-module (alterator lookout globals)
  :use-module (alterator lookout evaluation)

  :export (make-container-presentation
           with-container-presentations
	   prepare-container-presentation))


(define-operation params-of)

;;this helper allow to use to implement recursive definitions, like document:root
(define (prepare-container-presentation container url)
  (define-operation reset-context)
  
  (let* ((url-as-list (if (pair? url) url (list url)))
         (path (apply (from-context 'atlas) url-as-list)))
    (and path
         (with-globals (extend-globals '())
                       (reset-globals! (params-of path))
                       (set-global! 'document:root container)
		       (reset-context container)
		       
                       (container (make-init-attribute 'type 0 "root")) ;will be override by eval
                       (container (document:eval path))
                       container))))
  
(define (make-container-presentation url . default-args)
  (lambda args
    (let* ((len (length default-args))
           (first-args (map (lambda(x y) (x y)) default-args (take args len)))
           (rest-args (list-tail args len))
           (all-args (append first-args rest-args)))
      (let ((container (prepare-container-presentation (make-container) url)))
        (container all-args)
        container))))
       
(define-macro (with-container-presentations <presentations> <instruction> . <instructions>)
  `(let ,(map (lambda(item) `(,(car item) (make-container-presentation ,@(cdr item)))) <presentations>)
     ,<instruction> . ,<instructions>))

