(define-module (alterator mailbox)
  :use-module (srfi srfi-1)
  :use-module (alterator session common)
  :use-module (alterator woo)
  :use-module (alterator context)
  :export (add-mailbox
           remove-mailbox
           run-mailbox))

(define *callbacks* '())

(define (remove-mailbox proc)
  (set! *callbacks*
        (alist-delete proc *callbacks*)))

(define (add-mailbox proc)
  (let ((gate (fluid-ref woo-gate))
        (session (fluid-ref generic-session))
        (context (fluid-ref lookout-context)))
    (set!
     *callbacks*
     (acons proc
            (vector gate session context)
	    *callbacks*))))

(define (run-mailbox message)
  (for-each
   (lambda(info)
     (let* ((proc (car info))
            (fluids (cdr info))
            (gate (vector-ref fluids 0))
            (session (vector-ref fluids 1))
            (context (vector-ref fluids 2)))
       (with-fluids ((woo-gate gate)
                     (generic-session session)
                     (lookout-context context))
                    (proc message))))
   *callbacks*))
