(define-module (alterator pidfile)
    :export (check-pid
             write-pid))

(define (read-pid filename)
  (catch
      'system-error
    (lambda()
      (call-with-input-file
          filename
        (lambda(port) (read port))))
    (lambda args #f)))

;;TODO: lock file during writing
(define (write-pid filename)
  (call-with-output-file
      filename
    (lambda(port)
      (write (getpid) port)
      #t)))

(define (process-exists? pid)
  (catch 'system-error
    (lambda() (kill pid 0) #t)
    (lambda args
      (not (= (system-error-errno args) 3)))))

(define (check-pid filename)
  (let ((pid (read-pid filename)))
    (and (number? pid)
         (process-exists? pid))))
