(define-module (alterator ports)
  :use-module (alterator algo)
  :export (call-with-input-file/informative))

(define (call-with-input-file/informative str proc)
  (let ((file (open-input-file str)))
    (catch
       'misc-error
      (thunk
       (begin-1
        (proc file)
        (close-input-port file)))
      (lambda (key . args)
        (let ((proc (cond-car args))
              (msg  (cond-cadr args)))
        (apply throw 
	       'misc-error
               proc
               (format #f "~A:~A:~A:~A"
                        str
                        (+ (port-line file) 1)
                        (+ (port-column file) 1)
                        msg)
		args))))))
