(define-module (alterator presentation common)
  :use-module (alterator object)
  :use-module (alterator algo)
  :export ( make-attribute
            with-attributes
            
	    make-extended-attribute
            
            make-init-attribute
            with-init-attributes
	    initial?
            
            make-meta-attribute
            with-meta-attributes
            
	    make-proxy-holder
	    with-proxy-attributes
	    proxy?
	    
            with-keywords
            
            name-of
            value-of))

;;description: attributes and keywords support

(define-operation name-of)
(define-operation value-of (lambda(obj) obj))

;;basic attribute
(define (make-attribute name . rest)
  (let ((count (if (null? rest) 1 (car rest)))
        (value  (if (and (pair? rest) (pair? (cdr rest)))
                    (cdr rest)
                    '())))
    (object
     (lambda args
       (let ((new-count (length args)))
         (apply make-attribute
                name
                (- count new-count)
                (append value args))))
     ((instance-of self) (if (positive? count)
                             '<empty-attribute>
                             '<attribute>))
     ((name-of self) name)
     ((value-of self) value))))


(define-macro (with-attributes <attrlist> <instruction> . <instructions>)
  `(let ,(map (lambda (<attr>)
                (let ((attr-name (if (pair? <attr>) (car <attr>) <attr>))
                      (attr-rest (if (pair? <attr>) (cdr <attr>) '())))
                `(,attr-name (make-attribute ',attr-name ,@attr-rest))))
              <attrlist>)
     ,<instruction> . ,<instructions>))


;; basic attribute with extra slots
(define (make-extended-attribute orig-obj extra-obj)
  (join
   (lambda args
     (make-extended-attribute (apply orig-obj args) extra-obj))
   orig-obj
   extra-obj))

;; initial attribute (constructor parameter)
(define (make-init-attribute . args)
  (make-extended-attribute
   (apply make-attribute args)
   (object #f ((initial? self) #t))))

(define-operation initial? #f)

(define-macro (with-init-attributes <attrlist> <instruction> . <instructions>)
  `(let ,(map (lambda (<attr>)
                (let ((attr-name (if (pair? <attr>) (car <attr>) <attr>))
                      (attr-rest (if (pair? <attr>) (cdr <attr>) '())))
                `(,attr-name (make-init-attribute ',attr-name ,@attr-rest))))
              <attrlist>)
     ,<instruction> . ,<instructions>))


;; meta-attribute
(define-macro (make-meta-attribute <name> . <args>)
  (let ((count (or (and (pair? <args>)
                        (number? (car <args>))
                        (car <args>))
                   1))
        (slots (or (and (pair? <args>)
                        (number? (car <args>))
                        (cdr <args>))
                   <args>)))
    `(make-extended-attribute
      (make-attribute ',<name> ,count)
      (object #f
              ,@slots))))

(define-macro (with-meta-attributes <attrlist> <instruction> . <instructions>)
  `(let* ,(map (lambda (attr)
                      (let ((attr-name (car attr))
                            (attr-rest (cdr attr)))
                        `(,attr-name (make-meta-attribute ,attr-name ,@attr-rest))))
                    <attrlist>)
              ,<instruction> . ,<instructions>))

;; proxy-attribute
(define (make-proxy-holder attr)
  (join
   (object #f ((instance-of self) '<proxy-holder>))
   attr))

(define-macro (with-proxy-attributes <attrlist> <instruction> . <instructions>)
  (define (slot->apply x) `(make-proxy-holder ,(car x)))
  `(with-meta-attributes ,<attrlist>
                         (list ,@(map slot->apply <attrlist>)
                               ,<instruction> . ,<instructions>)))
                         
(define (proxy? obj)
  (or (procedure? (select-operation obj 'proxy-get))
      (procedure? (select-operation obj 'proxy-set))))

;; keyword
(define-macro (with-keywords <keywordlist> <instruction> . <instructions>)
  `(let ,(map (lambda(<keyword>) `(,<keyword> ',<keyword>)) <keywordlist>)
     ,<instruction> . ,<instructions>))

