;user's session in http look of alterator
(define-module (alterator session loop)
  :use-module (srfi srfi-2)
  :use-module (alterator r6rs)
  :use-module (alterator algo)
  :use-module (alterator str)
  :use-module (alterator object)
  :use-module (alterator woo)

  :use-module (alterator session common)
  :use-module (alterator presentation common)

  :export (make-loop))

;user's session in http look of alterator

(define-operation get-widget)

(define (process-value value)
  (if (string? value)
      (string-cut value #\;)
      (list value)))

;;invisible set for "event" request
(define (do-silent-set state-description)
  (define-operation simple-set)

  (and-let* ((id (sure-symbol (car state-description)))
             (widget (get-widget (fluid-ref generic-session) id))
             (attrs (cdr state-description)))
            (for-each (lambda (attr)
                        (let ((name (car attr))
                              (value (cdr attr)))
                          (or (null? value) (simple-set widget (make-attribute name 0 value)))))
                      attrs)))

;;process incoming loop requests
(define (process-request popup cmd)
  (and (pair? cmd)
       (let ((action (woo-get-option cmd 'action #f)))
         (and action
              (case (sure-symbol action)
                ((get) (get-command popup))
                ((re-get) #t);only return current output queue
                ((event) (event-command popup cmd))
                (else (error "unknown action" action)))))))

;;process "get url" request
(define (get-command popup)
  (define-operation recreate)
  (recreate popup))

;;process "event emit" request
(define (event-command popup cmd)
  (define-operation call)
  
  (and-let* ((name (woo-get-option cmd 'name #f))
             (id   (woo-get-option cmd 'widget-id #f))
             (state (woo-get-option cmd 'state #f)))
            (for-each do-silent-set state);;first process state here
	    (let ((widget (get-widget (fluid-ref generic-session) id)))
              ;;then run appopriate callback
              (and widget (call widget (make-attribute (sure-symbol name)))))))

(define (make-loop)
  (define-operation pause)
  (define-operation start)
  
  (let ((do-loop #t)
        (session (fluid-ref generic-session))
        (ret-value (unspecified)))
    (object
     #f
     ((need-loop self)
      do-loop)
     ((re-start self popup)
      (set! do-loop #t)
      (start self popup))
     ((start self popup)
      (and do-loop
           (begin
              (let modal-loop ((msg (pause session)))
                (and msg (process-request popup msg))
                (and do-loop (modal-loop (pause session))))))
      ret-value)
      ((stop self arg)
       (set! ret-value arg)
       (set! do-loop #f)))))
