(define-module (alterator str)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-13)
  :use-module (alterator algo)
  :use-module (alterator container)
  :export (
           sure-string ;deprecated
	   ->string
           
           empty-string?
           not-empty-string?
           
           string-cut
           string-cut-repeated

           safe-substring
           string-quote))

;;use guile internal function
(define string-cut string-split)

;description: additional usefull functions for strings

(define (empty-string? str) (and (string? str) (string-null? str)))
(define (not-empty-string? str) (and (string? str) (not (string-null? str))))

;deprecated version of all-to-string transformer
(define (sure-string obj)
  (cond
   ((string? obj) obj)
   ((boolean? obj) (if obj "true" "false"))
   ((symbol? obj) (symbol->string obj))
   ((number? obj) (number->string obj))
   (else (error "unknown object type for sure-string" obj))))

;transform any datum to string
(define (->string obj)
  (cond
   ((string? obj) obj)
   ((symbol? obj) (symbol->string obj))
   ((number? obj) (number->string obj))
   (else
    (call-with-output-string
     (lambda(port) (display obj port))))))

(define (string-cut-repeated str separator)
  (delete "" (string-cut str separator)))

;;substring version with ignoring bad values
(define (safe-substring str start stop)
  (if (and (number? start)
           (number? stop)
           (< start stop (string-length str)))
      (substring str start stop)
      str))

;general quotation engine for the string
(define (string-quote quote-proc str)
  (let* ((len (string-length str))
         (new-len (string-fold (lambda (ch count)
                                 (+ count (string-length (quote-proc ch))))
                               0
                               str))
         (new-str (make-string new-len)))
    (let loop ((i 0)
               (new-i 0))
      (if (>= i len) new-str
          (loop (+ i 1) (container-replace! new-str (quote-proc (string-ref str i)) new-i))))))
