(define-module (alterator transport cmdline-channel)
  :use-module (srfi srfi-1)
  :use-module (alterator plist)
  :use-module (alterator woo)
  :use-module (alterator algo)
  :export(cmdline-in))

(define (cmdline->cmd cmdline)
  (and (pair? cmdline)
       (plist? (cdr cmdline))
       (cons (car cmdline)
             (reverse (plist-fold (lambda(x y res) (cons* y (string->symbol x) res))
                                 '()
                                 (cdr cmdline))))))

(define (cmdline-in cmdline)
  (lambda (cmds next)
    (let ((cmd (cmdline->cmd cmdline)))
      (and cmd
           (woo-catch
            (thunk
              (write (woo-try-cmds (next (list cmd))))
              (newline))
            (lambda(reason)
	      (write '())
	      (newline)
              (format (current-error-port) "fatal error:~S~%" reason)
              (exit 1)))))))
