(define-module (alterator transport pipe-channel)
  :use-module (alterator pipe)
  :use-module (alterator algo)
  :use-module (alterator session xml)
  :export (pipe-in))

(define next-gate (make-fluid))

(define (process-incoming next ports)
  (let* ((cmd (read (port-for-read ports)))
         (ans (or (eof-object? cmd)
                  (car (next (list cmd)) ))))
    (eat-rest (port-for-read ports))
    (and (eof-object? cmd) (quit))
    (with-ignored-sigpipe
     (thunk
      (and (pair? ans)
           (let ((out (port-for-write ports)))
             (display (auth->xml ans) out) )))))
  (process-incoming next ports))

(define (pipe-in command . args)
  (let ((ports (apply create-process 'read-write  command args)))
    (lambda (cmds next)
      (process-incoming next ports))))
